/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks;

import betterwithmods.common.BWMRecipes;
import betterwithmods.module.gameplay.miniblocks.ItemMini;
import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MiniRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public Block start;
    public Block end;

    public MiniRecipe(Block start, Block end) {
        this.start = start;
        this.end = end;
        this.setRegistryName(start.getRegistryName());
    }

    public boolean matches(InventoryCrafting inv, World worldIn) {
        ItemStack[] stacks = new ItemStack[2];
        int matches = 0;
        for (int x = 0; x < inv.getSizeInventory(); ++x) {
            Block block;
            boolean inRecipe = false;
            ItemStack stack = inv.getStackInSlot(x);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ItemMini && matches <= 1 && (block = ((ItemMini)stack.getItem()).getBlock()) == this.start) {
                stacks[matches] = stack;
                inRecipe = true;
                ++matches;
            }
            if (inRecipe) continue;
            return false;
        }
        return ItemMini.matches(stacks[0], stacks[1]);
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack first = ItemStack.EMPTY;
        for (int x = 0; x < inv.getSizeInventory(); ++x) {
            ItemStack stack = inv.getStackInSlot(x);
            if (stack.isEmpty() || !(stack.getItem() instanceof ItemMini)) continue;
            first = stack;
            break;
        }
        return this.getOutput(first);
    }

    public boolean canFit(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getRecipeOutput() {
        return ItemStack.EMPTY;
    }

    public ItemStack getStart() {
        return new ItemStack(this.start);
    }

    public ItemStack getEnd() {
        return new ItemStack(this.end);
    }

    public ItemStack getOutput(ItemStack input) {
        ItemStack result = ItemStack.EMPTY;
        if (!input.isEmpty()) {
            if (this.end instanceof BlockMini) {
                result = new ItemStack(this.end);
                NBTTagCompound tag = input.getTagCompound();
                result.setTagCompound(tag);
            } else {
                IBlockState state = ItemMini.getState(input);
                if (state != null) {
                    result = BWMRecipes.getStackFromState(state);
                }
            }
        }
        return result;
    }
}

