/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay.miniblocks;

import betterwithmods.module.gameplay.miniblocks.blocks.BlockMini;
import betterwithmods.module.gameplay.miniblocks.tiles.TileMini;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemMini
extends ItemBlock {
    public ItemMini(Block block) {
        super(block);
    }

    public static IBlockState getState(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.getItem() instanceof ItemMini && (tag = stack.getSubCompound("texture")) != null) {
            return NBTUtil.readBlockState((NBTTagCompound)tag);
        }
        return null;
    }

    public static boolean matches(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (!(a.getItem() instanceof ItemMini) || !(b.getItem() instanceof ItemMini)) {
            return false;
        }
        ItemMini miniA = (ItemMini)a.getItem();
        ItemMini miniB = (ItemMini)b.getItem();
        if (miniA.getBlock() != miniB.getBlock()) {
            return false;
        }
        IBlockState stateA = ItemMini.getState(a);
        IBlockState stateB = ItemMini.getState(b);
        return stateA != null & stateB != null && stateA.equals(stateB);
    }

    public static boolean placeBlockAt(ItemMini item, ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.setBlockState(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == item.block) {
            ItemMini.setTileEntityNBT((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            TileEntity tile = world.getTileEntity(pos);
            if (tile instanceof TileMini) {
                ItemMini.setNBT((TileMini)tile, world, stack);
            }
            ((BlockMini)item.block).onBlockPlacedBy(world, pos, state, (EntityLivingBase)player, stack, side, hitX, hitY, hitZ);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.PLACED_BLOCK.trigger((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }

    public static void setNBT(TileMini tile, World worldIn, ItemStack stackIn) {
        MinecraftServer minecraftserver = worldIn.getMinecraftServer();
        if (minecraftserver == null) {
            return;
        }
        NBTTagCompound data = stackIn.getSubCompound("miniblock");
        if (data != null) {
            if (!worldIn.isRemote && tile.onlyOpsCanSetNbt()) {
                return;
            }
            NBTTagCompound tileNBT = tile.writeToNBT(new NBTTagCompound());
            NBTTagCompound newNBT = tileNBT.copy();
            tileNBT.merge(data);
            if (!tileNBT.equals((Object)newNBT)) {
                tile.readFromNBT(tileNBT);
                tile.markDirty();
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        return ItemMini.placeBlockAt(this, stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    public String getItemStackDisplayName(ItemStack stack) {
        IBlockState state;
        ItemStack block;
        NBTTagCompound tag = stack.getSubCompound("texture");
        String type = I18n.translateToLocal((String)"bwm.unknown_mini.name").trim();
        if (tag != null && (block = new ItemStack((state = NBTUtil.readBlockState((NBTTagCompound)tag)).getBlock(), 1, state.getBlock().getMetaFromState(state))).getItem() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)block.getItem();
            type = itemBlock.getItemStackDisplayName(block);
        }
        return I18n.translateToLocalFormatted((String)(this.getUnlocalizedName(stack) + ".name"), (Object[])new Object[]{type});
    }
}

