/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.needs.HCTools;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;

public class MetalReclaming
extends Feature {
    public static int reclaimCount;

    public static void addReclaimRecipe(ItemStack input, String oreSuffix, int ingotCount) {
        int totalNuggets = ingotCount * reclaimCount;
        int ingots = totalNuggets / 9;
        int nuggets = totalNuggets % 9;
        ItemStack ingotStack = ItemStack.EMPTY;
        ItemStack nuggetStack = ItemStack.EMPTY;
        if (ingots > 0 && !OreDictionary.getOres((String)("ingot" + oreSuffix)).isEmpty()) {
            ingotStack = (ItemStack)OreDictionary.getOres((String)("ingot" + oreSuffix)).get(0);
        }
        if (nuggets > 0 && !OreDictionary.getOres((String)("nugget" + oreSuffix)).isEmpty()) {
            nuggetStack = (ItemStack)OreDictionary.getOres((String)("nugget" + oreSuffix)).get(0);
        }
        ArrayList outputs = Lists.newArrayList();
        if (ingotStack.isEmpty()) {
            if (!nuggetStack.isEmpty()) {
                outputs.add(new ItemStack(nuggetStack.getItem(), totalNuggets > nuggets ? totalNuggets : nuggets, nuggetStack.getMetadata()));
            }
        } else {
            outputs.add(new ItemStack(ingotStack.getItem(), ingots, ingotStack.getMetadata()));
            if (!nuggetStack.isEmpty()) {
                outputs.add(new ItemStack(nuggetStack.getItem(), nuggets, nuggetStack.getMetadata()));
            }
        }
        BWRegistry.CRUCIBLE.addStokedRecipe(input, (List<ItemStack>)outputs);
    }

    @Override
    public String getFeatureDescription() {
        return "Adds recipes to the Crucible to melt metal items back into their component metals";
    }

    @Override
    public void setupConfig() {
        reclaimCount = this.loadPropInt("Reclaming Count", "Amount (in nuggets per ingot) tools and armor in the crucible reclaim. Does not affect diamond or soulforged steel ingot reclamation. (Set to 0 to disable reclamation entirely.)", "", 6, 0, 9);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        int axe_amt;
        int n = axe_amt = HCTools.changeAxeRecipe ? 2 : 3;
        if (reclaimCount > 0) {
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_HOE, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_SWORD, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_PICKAXE, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_AXE, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, axe_amt));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_SHOVEL, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_MATTOCK, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 4));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_BATTLEAXE, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 5));
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.IRON_CHESTPLATE, 1, Short.MAX_VALUE), "Iron", 8);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.IRON_AXE, 1, Short.MAX_VALUE), "Iron", axe_amt);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.IRON_BOOTS, 1, Short.MAX_VALUE), "Iron", 4);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.IRON_HELMET, 1, Short.MAX_VALUE), "Iron", 5);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.IRON_LEGGINGS, 1, Short.MAX_VALUE), "Iron", 7);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.IRON_HOE, 1, Short.MAX_VALUE), "Iron", 2);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.IRON_PICKAXE, 1, Short.MAX_VALUE), "Iron", 3);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.IRON_SHOVEL, 1, Short.MAX_VALUE), "Iron", 1);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.IRON_SWORD, 1, Short.MAX_VALUE), "Iron", 2);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.GOLDEN_CHESTPLATE, 1, Short.MAX_VALUE), "Gold", 8);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.GOLDEN_AXE, 1, Short.MAX_VALUE), "Gold", axe_amt);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.GOLDEN_BOOTS, 1, Short.MAX_VALUE), "Gold", 4);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.GOLDEN_HELMET, 1, Short.MAX_VALUE), "Gold", 5);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.GOLDEN_LEGGINGS, 1, Short.MAX_VALUE), "Gold", 7);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.GOLDEN_HOE, 1, Short.MAX_VALUE), "Gold", 2);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.GOLDEN_PICKAXE, 1, Short.MAX_VALUE), "Gold", 3);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.GOLDEN_SHOVEL, 1, Short.MAX_VALUE), "Gold", 1);
            MetalReclaming.addReclaimRecipe(new ItemStack(Items.GOLDEN_SWORD, 1, Short.MAX_VALUE), "Gold", 2);
            MetalReclaming.addReclaimRecipe(new ItemStack((Item)Items.SHEARS, 1, Short.MAX_VALUE), "Iron", 2);
            BWRegistry.CRUCIBLE.addStokedRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_HELMET, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 10));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_CHEST, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 14));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_PANTS, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 12));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMItems.STEEL_BOOTS, 1, Short.MAX_VALUE), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 8));
            BWRegistry.CRUCIBLE.addStokedRecipe(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHAIN_MAIL), new ItemStack(Items.IRON_NUGGET, 4));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Item)Items.CHAINMAIL_HELMET, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_NUGGET, 20));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Item)Items.CHAINMAIL_LEGGINGS, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_NUGGET, 32));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Item)Items.CHAINMAIL_CHESTPLATE, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_NUGGET, 28));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Item)Items.CHAINMAIL_BOOTS, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_NUGGET, 16));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.SHIELD, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_INGOT, 1));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.IRON_DOOR), new ItemStack(Items.IRON_INGOT, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.IRON_HORSE_ARMOR, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_INGOT, 8));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.GOLDEN_HORSE_ARMOR, 1, Short.MAX_VALUE), new ItemStack(Items.GOLD_INGOT, 8));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.MINECART), new ItemStack(Items.IRON_INGOT, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.CHEST_MINECART), new ItemStack(Items.IRON_INGOT, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.FURNACE_MINECART), new ItemStack(Items.IRON_INGOT, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.HOPPER_MINECART), new ItemStack(Items.IRON_INGOT, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.TNT_MINECART), new ItemStack(Items.IRON_INGOT, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Items.CAULDRON), new ItemStack(Items.IRON_INGOT, 7));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.RAIL, 8), new ItemStack(Items.IRON_INGOT, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.GOLDEN_RAIL, 6), new ItemStack(Items.GOLD_INGOT, 6));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.ACTIVATOR_RAIL, 6), new ItemStack(Items.IRON_INGOT, 6));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.IRON_BARS, 8), new ItemStack(Items.IRON_INGOT, 3));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.ANVIL, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_INGOT, 31));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack((Block)Blocks.HOPPER, 1, Short.MAX_VALUE), new ItemStack(Items.IRON_INGOT, 5));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, 1), new ItemStack(Items.IRON_INGOT, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, 1), new ItemStack(Items.GOLD_INGOT, 2));
            BWRegistry.CRUCIBLE.addStokedRecipe(new ItemStack(BWMBlocks.STEEL_ANVIL), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL, 7));
        }
    }
}

