/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.tile.TileEntityWaterwheel;
import betterwithmods.module.ConfigHelper;
import betterwithmods.module.Module;
import betterwithmods.module.gameplay.AnvilRecipes;
import betterwithmods.module.gameplay.CauldronRecipes;
import betterwithmods.module.gameplay.CraftingRecipes;
import betterwithmods.module.gameplay.CrucibleRecipes;
import betterwithmods.module.gameplay.HarderSteelRecipe;
import betterwithmods.module.gameplay.HopperRecipes;
import betterwithmods.module.gameplay.KilnRecipes;
import betterwithmods.module.gameplay.MechanicalBreakage;
import betterwithmods.module.gameplay.MetalReclaming;
import betterwithmods.module.gameplay.MillRecipes;
import betterwithmods.module.gameplay.NetherGrowth;
import betterwithmods.module.gameplay.NuggetCompression;
import betterwithmods.module.gameplay.PlayerDataHandler;
import betterwithmods.module.gameplay.ReadTheFingManual;
import betterwithmods.module.gameplay.SawRecipes;
import betterwithmods.module.gameplay.TurntableRecipes;
import betterwithmods.module.gameplay.breeding_harness.BreedingHarness;
import betterwithmods.module.gameplay.miniblocks.MiniBlocks;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class Gameplay
extends Module {
    public static double generatorRenderDistance;
    public static double crankExhaustion;
    public static boolean kidFriendly;
    public static boolean disableBlastingOilEvents;
    public static float cauldronNormalSpeedFactor;
    public static float cauldronStokedSpeedFactor;
    public static float cauldronMultipleFiresFactor;
    public static boolean dropHempSeeds;
    private String[] waterwheelFluidConfig;
    public static List<String> blacklistDamageSources;

    @Override
    public void addFeatures() {
        this.registerFeature(new MechanicalBreakage());
        this.registerFeature(new MetalReclaming());
        this.registerFeature(new NuggetCompression());
        this.registerFeature(new HarderSteelRecipe());
        this.registerFeature(new AnvilRecipes());
        this.registerFeature(new CraftingRecipes());
        this.registerFeature(new CauldronRecipes());
        this.registerFeature(new CrucibleRecipes());
        this.registerFeature(new KilnRecipes());
        this.registerFeature(new MillRecipes());
        this.registerFeature(new SawRecipes());
        this.registerFeature(new TurntableRecipes());
        this.registerFeature(new HopperRecipes());
        this.registerFeature(new NetherGrowth());
        this.registerFeature(new BreedingHarness().recipes());
        this.registerFeature(new PlayerDataHandler());
        this.registerFeature(new ReadTheFingManual());
        this.registerFeature(new MiniBlocks());
    }

    @Override
    public void setupConfig() {
        generatorRenderDistance = this.loadPropDouble("Render Distance for Axle Generators", "Allows expanding the render distance radius for Windmills and Waterwheels", 256.0);
        crankExhaustion = this.loadPropDouble("Crank Exhaustion", "How much saturation turning the crank eats. Set to 0.0 to disable.", 6.0, 0.0, 6.0);
        kidFriendly = this.loadPropBool("Kid Friendly", "Makes some features more kid friendly", false);
        disableBlastingOilEvents = this.loadPropBool("Disable Blasting Oil", "Don't process blasting oil explosions, as they are have major performance impact", false);
        this.loadRecipeCondition("higheff", "High Efficiency Recipes", "Enables High Efficiency Recipes", true);
        cauldronNormalSpeedFactor = (float)this.loadPropDouble("Cauldron normal speed factor", "Cooking speed multiplier for unstoked cauldrons.", 1.0);
        cauldronStokedSpeedFactor = (float)this.loadPropDouble("Cauldron stoked speed factor", "Cooking speed multiplier for stoked cauldrons and crucibles.", 1.0);
        cauldronMultipleFiresFactor = (float)this.loadPropDouble("Cauldron Multiple fires factor", "Sets how strongly multiple fire sources (in a 3x3 grid below the pot) affect cooking times.", 1.0);
        dropHempSeeds = this.loadPropBool("Drop Hemp Seeds", "Adds Hemp seeds to the grass seed drop list.", true);
        this.waterwheelFluidConfig = ConfigHelper.loadPropStringList("Waterwheel fluids", this.name, "Fluids which will allow the Waterwheel to turn, format fluid_name", new String[]{"swamp_water"});
        blacklistDamageSources = Lists.newArrayList((Object[])ConfigHelper.loadPropStringList("Blasting oil damage source blacklist", this.name, "Disallow these damage sources from disturbing blasting oil", new String[]{"drown", "cramming", "generic", "wither", "starve", "outOfWorld"}));
        super.setupConfig();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        if (dropHempSeeds) {
            MinecraftForge.addGrassSeed((ItemStack)new ItemStack(BWMBlocks.HEMP, 1), (int)5);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        Arrays.stream(this.waterwheelFluidConfig).map(FluidRegistry::getFluid).filter(Objects::nonNull).collect(Collectors.toList()).forEach(fluid -> TileEntityWaterwheel.registerWater(fluid.getBlock()));
    }
}

