/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.gameplay;

import betterwithmods.BWMod;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.anvil.AnvilCraftingManager;
import betterwithmods.common.registry.anvil.ShapedAnvilRecipe;
import betterwithmods.common.registry.anvil.ShapelessAnvilRecipe;
import betterwithmods.module.Feature;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.miniblocks.MiniBlockIngredient;
import betterwithmods.module.hardcore.needs.HCTools;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreIngredient;

public class AnvilRecipes
extends Feature {
    public AnvilRecipes() {
        this.canDisable = false;
    }

    public static ShapedAnvilRecipe addSteelShapedRecipe(String recipeName, ItemStack output, Object ... input) {
        return AnvilRecipes.addSteelShapedRecipe(new ResourceLocation("betterwithmods", recipeName), output, input);
    }

    public static ShapedAnvilRecipe addSteelShapedRecipe(ResourceLocation recipeName, ItemStack output, Object ... input) {
        if (recipeName == null || recipeName.toString().isEmpty()) {
            BWMod.logger.warn("Anvil Recipe is missing recipeName" + output);
            recipeName = output.getItem().getRegistryName();
        }
        ShapedAnvilRecipe recipe = new ShapedAnvilRecipe(null, output, input);
        AnvilRecipes.addAnvilRecipe((IRecipe)recipe.setRegistryName(recipeName));
        return recipe;
    }

    public static ShapelessAnvilRecipe addSteelShapelessRecipe(String recipeName, ItemStack output, Object ... input) {
        return AnvilRecipes.addSteelShapelessRecipe(new ResourceLocation("betterwithmods", recipeName), output, input);
    }

    public static ShapelessAnvilRecipe addSteelShapelessRecipe(ResourceLocation recipeName, ItemStack output, Object ... input) {
        if (recipeName == null || recipeName.toString().isEmpty()) {
            BWMod.logger.warn("Anvil Recipe is missing recipeName" + output);
            recipeName = output.getItem().getRegistryName();
        }
        ShapelessAnvilRecipe recipe = new ShapelessAnvilRecipe(null, output, input);
        AnvilRecipes.addAnvilRecipe((IRecipe)recipe.setRegistryName(recipeName));
        return recipe;
    }

    private static IRecipe addAnvilRecipe(IRecipe recipe) {
        AnvilCraftingManager.ANVIL_CRAFTING.add(recipe);
        if (recipe.getRecipeOutput().isEmpty()) {
            BWMod.logger.warn("Recipe is missing output " + recipe.getGroup());
        }
        return recipe;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        AnvilRecipes.addSteelShapedRecipe("block_dispenser", new ItemStack(BWMBlocks.BLOCK_DISPENSER), "MMMM", "MUUM", "STTS", "SRRS", Character.valueOf('M'), Blocks.MOSSY_COBBLESTONE, Character.valueOf('U'), new ItemStack(BWMBlocks.URN, 1, 8), Character.valueOf('S'), "stone", Character.valueOf('R'), "dustRedstone", Character.valueOf('T'), Blocks.REDSTONE_TORCH);
        AnvilRecipes.addSteelShapedRecipe("buddy_block", new ItemStack(BWMBlocks.BUDDY_BLOCK), "SSLS", "LTTS", "STTL", "SLSS", Character.valueOf('S'), "stone", Character.valueOf('T'), Blocks.REDSTONE_TORCH, Character.valueOf('L'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POLISHED_LAPIS));
        AnvilRecipes.addSteelShapedRecipe("detector", new ItemStack(BWMBlocks.DETECTOR), "CCCC", "LTTL", "SRRS", "SRRS", Character.valueOf('C'), "cobblestone", Character.valueOf('L'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POLISHED_LAPIS), Character.valueOf('T'), Blocks.REDSTONE_TORCH, Character.valueOf('S'), "stone", Character.valueOf('R'), "dustRedstone");
        AnvilRecipes.addSteelShapedRecipe("steel_helmet", new ItemStack(BWMItems.STEEL_HELMET), "SSSS", "S  S", "S  S", " PP ", Character.valueOf('P'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), Character.valueOf('S'), "ingotSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("steel_chest", new ItemStack(BWMItems.STEEL_CHEST), "P  P", "SSSS", "SSSS", "SSSS", Character.valueOf('P'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), Character.valueOf('S'), "ingotSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("steel_pants", new ItemStack(BWMItems.STEEL_PANTS), "SSSS", "PSSP", "P  P", "P  P", Character.valueOf('P'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), Character.valueOf('S'), "ingotSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("steel_boots", new ItemStack(BWMItems.STEEL_BOOTS), " SS ", " SS ", "SPPS", Character.valueOf('P'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), Character.valueOf('S'), "ingotSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("polished_lapis", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POLISHED_LAPIS, 2), "LLL", "LLL", "GGG", " R ", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "nuggetGold");
        if (ModuleLoader.isFeatureEnabled(HCTools.class)) {
            AnvilRecipes.addSteelShapedRecipe("steel_axe", new ItemStack(BWMItems.STEEL_AXE), "X ", "XH", " H", " H", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        } else {
            AnvilRecipes.addSteelShapedRecipe("steel_axe", new ItemStack(BWMItems.STEEL_AXE), "XX", "XH", " H", " H", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        }
        AnvilRecipes.addSteelShapedRecipe("steel_hoe", new ItemStack(BWMItems.STEEL_HOE), "XX", " H", " H", " H", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        AnvilRecipes.addSteelShapedRecipe("steel_pickaxe", new ItemStack(BWMItems.STEEL_PICKAXE), "XXX", " H ", " H ", " H ", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        AnvilRecipes.addSteelShapedRecipe("steel_shovel", new ItemStack(BWMItems.STEEL_SHOVEL), "X", "H", "H", "H", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        AnvilRecipes.addSteelShapedRecipe("steel_sword", new ItemStack(BWMItems.STEEL_SWORD), "X", "X", "X", "H", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        AnvilRecipes.addSteelShapedRecipe("steel_battleaxe", new ItemStack(BWMItems.STEEL_BATTLEAXE), "XXX", "XHX", " H ", " H ", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        AnvilRecipes.addSteelShapedRecipe("steel_mattock", new ItemStack(BWMItems.STEEL_MATTOCK), " XXX", "X H ", "  H ", "  H ", Character.valueOf('X'), "ingotSoulforgedSteel", Character.valueOf('H'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HAFT));
        AnvilRecipes.addSteelShapedRecipe("armor_plate", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.ARMOR_PLATE), "BSPB", Character.valueOf('B'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.LEATHER_STRAP), Character.valueOf('S'), "ingotSoulforgedSteel", Character.valueOf('P'), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.PADDING));
        AnvilRecipes.addSteelShapedRecipe("broadhead", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BROADHEAD, 6), " N ", " N ", "NNN", " N ", Character.valueOf('N'), "nuggetSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("steel_block", new ItemStack(BWMBlocks.STEEL_BLOCK), "XXXX", "XXXX", "XXXX", "XXXX", Character.valueOf('X'), "ingotSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("chopping_block", new ItemStack(BWMBlocks.AESTHETIC, 6, 0), "X  X", "XXXX", Character.valueOf('X'), "stone");
        AnvilRecipes.addSteelShapedRecipe("chain_mail", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHAIN_MAIL, 2), "N N ", " N N", "N N ", " N N", Character.valueOf('N'), "nuggetIron");
        AnvilRecipes.addSteelShapedRecipe("steel_gear", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_GEAR), " NN ", "NIIN", "NIIN", " NN ", Character.valueOf('N'), "nuggetSoulforgedSteel", Character.valueOf('I'), "ingotSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("steel_spring", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_SPRING), "NNN", "NNN", "NNN", "NNN", Character.valueOf('N'), "nuggetSoulforgedSteel");
        AnvilRecipes.addSteelShapedRecipe("iron_wall", new ItemStack(BWMBlocks.IRON_WALL, 8, 0), "XXXX", "XXXX", "XXXX", "XXXX", Character.valueOf('X'), new ItemStack(Blocks.IRON_BARS));
        AnvilRecipes.addSteelShapedRecipe("steel_gearbox", new ItemStack(BWMBlocks.STEEL_GEARBOX), "SGSS", "SGLG", "GLGS", "SSGS", Character.valueOf('S'), "ingotSoulforgedSteel", Character.valueOf('G'), "gearSoulforgedSteel", Character.valueOf('L'), "latchRedstone");
        AnvilRecipes.addSteelShapedRecipe("steel_hacksaw", new ItemStack(BWMItems.STEEL_HACKSAW), new Object[]{"NMM", "N M", "N M", "NMM", Character.valueOf('N'), "nuggetSoulforgedSteel", Character.valueOf('M'), new MiniBlockIngredient("moulding", (Ingredient)new OreIngredient("plankWood"))});
        AnvilRecipes.addSteelShapedRecipe("steel_axle", new ItemStack(BWMBlocks.STEEL_AXLE, 2), "  NG", " NBN", "NBN ", "GN  ", Character.valueOf('N'), "nuggetSoulforgedSteel", Character.valueOf('G'), "gearSoulforgedSteel", Character.valueOf('B'), "hideBelt");
        AnvilRecipes.addSteelShapedRecipe("steel_pressure_plate", new ItemStack(BWMBlocks.STEEL_PRESSURE_PLATE, 2), "IIII", " RR ", Character.valueOf('I'), "ingotSoulforgedSteel", Character.valueOf('R'), "dustRedstone");
        AnvilRecipes.addSteelShapedRecipe("lightning_rod", new ItemStack(BWMBlocks.CANDLE_HOLDER, 2), "N", "N", "N", "I", Character.valueOf('I'), "ingotSoulforgedSteel", Character.valueOf('N'), "nuggetSoulforgedSteel");
    }
}

