/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module;

import betterwithmods.BWMod;
import betterwithmods.module.CompatFeature;
import betterwithmods.module.Module;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CompatModule
extends Module {
    private HashMap<String, String> compatRegistry = Maps.newHashMap();

    public void registerCompatFeature(String modid, String clazz) {
        this.compatRegistry.put(modid, clazz);
    }

    public void addCompatFeatures() {
        this.registerCompatFeature("biomesoplenty", "betterwithmods.module.compat.bop.BiomesOPlenty");
        this.registerCompatFeature("harvestcraft", "betterwithmods.module.compat.Harvestcraft");
        this.registerCompatFeature("quark", "betterwithmods.module.compat.Quark");
        this.registerCompatFeature("actuallyadditions", "betterwithmods.module.compat.ActuallyAdditions");
        this.registerCompatFeature("immersiveengineering", "betterwithmods.module.compat.immersiveengineering.ImmersiveEngineering");
        this.registerCompatFeature("dynamictrees", "betterwithmods.module.compat.DynamicTrees");
        this.registerCompatFeature("thaumcraft", "betterwithmods.module.compat.thaumcraft.Thaumcraft");
    }

    @Override
    public void addFeatures() {
        this.addCompatFeatures();
        this.load();
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    public void load() {
        for (Map.Entry<String, String> feature : this.compatRegistry.entrySet()) {
            String modId = feature.getKey();
            String classPath = feature.getValue();
            if (!this.isLoaded(modId)) continue;
            try {
                this.registerFeature(Class.forName(classPath).asSubclass(CompatFeature.class).newInstance());
                FMLLog.info((String)(" [BWM] Successfully load compat for " + modId), (Object[])new Object[0]);
            }
            catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | InstantiationException ignore) {
                BWMod.logger.info(" [BWM] Compatibility class " + classPath + " could not be loaded. Report this!");
            }
        }
    }

    private boolean isLoaded(String modId) {
        boolean loaded = this.loadPropBool(modId.toLowerCase() + "_compat", String.format("Requires %s to be installed", modId), true) && Loader.isModLoaded((String)modId);
        return loaded;
    }

    public ItemStack getItem(String location) {
        return this.getItem(new ResourceLocation(location), 1, 0);
    }

    public ItemStack getItem(ResourceLocation location, int count, int meta) {
        return new ItemStack((Item)Item.REGISTRY.getObject((Object)location), count, meta);
    }

    public ItemStack getItem(String location, int count, int meta) {
        return this.getItem(new ResourceLocation(location), count, meta);
    }

    public ItemStack getBlock(ResourceLocation location, int count, int meta) {
        return new ItemStack((Block)Block.REGISTRY.getObject((Object)location), count, meta);
    }

    public ItemStack getBlock(String location, int count, int meta) {
        return this.getBlock(new ResourceLocation(location), count, meta);
    }

    public ItemStack getBlock(String location) {
        return this.getBlock(new ResourceLocation(location), 1, 0);
    }
}

