/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.common.item;

import betterwithmods.manual.api.detail.ManualDefinition;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ItemBookManual
extends ItemBook {
    private final ManualDefinition myManual;

    public ItemBookManual() {
        this.myManual = ManualDefinitionImpl.INSTANCE;
    }

    public ItemBookManual(ManualDefinition m) {
        this.myManual = m;
    }

    public static boolean tryOpenManual(ManualDefinition manual, World world, EntityPlayer player, @Nullable String path) {
        if (path == null) {
            return false;
        }
        if (world.isRemote) {
            manual.openFor(player);
            manual.reset();
            manual.navigate(path);
        }
        return true;
    }

    @Deprecated
    public static boolean tryOpenManual(World world, EntityPlayer player, @Nullable String path) {
        return ItemBookManual.tryOpenManual(ManualDefinitionImpl.INSTANCE, world, player, path);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemBookManual.tryOpenManual(this.myManual, world, player, this.myManual.pathFor(world, pos)) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (world.isRemote) {
            if (player.isSneaking()) {
                this.myManual.reset();
            }
            this.myManual.openFor(player);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.getHeldItem(hand));
        }
        return super.onItemRightClick(world, player, hand);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }
}

