/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.manual;

import betterwithmods.manual.api.manual.ImageRenderer;
import betterwithmods.manual.client.manual.segment.BoldSegment;
import betterwithmods.manual.client.manual.segment.CodeSegment;
import betterwithmods.manual.client.manual.segment.HeaderSegment;
import betterwithmods.manual.client.manual.segment.InteractiveSegment;
import betterwithmods.manual.client.manual.segment.ItalicSegment;
import betterwithmods.manual.client.manual.segment.LinkSegment;
import betterwithmods.manual.client.manual.segment.Segment;
import betterwithmods.manual.client.manual.segment.SegmentRefiner;
import betterwithmods.manual.client.manual.segment.StrikethroughSegment;
import betterwithmods.manual.client.manual.segment.TextSegment;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import betterwithmods.manual.custom.JEIRenderSegment;
import betterwithmods.manual.custom.JEISegment;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public final class Document {
    public static final Set<PatternMapping> SEGMENT_TYPES = Sets.newHashSet((Object[])new PatternMapping[]{new PatternMapping("^(#+)\\s(.*)", Document::HeaderSegment), new PatternMapping("(`)(.*?)\\1", Document::CodeSegment), new PatternMapping("!\\[([^\\[]*)\\]\\(([^\\)]+)\\)", Document::ImageSegment), new PatternMapping("\\[([^\\[]+)\\]\\(([^\\)]+)\\)", Document::LinkSegment), new PatternMapping("(\\*\\*|__)(\\S.*?\\S|$)\\1", Document::BoldSegment), new PatternMapping("(\\*|_)(\\S.*?\\S|$)\\1", Document::ItalicSegment), new PatternMapping("~~(\\S.*?\\S|$)~~", Document::StrikethroughSegment)});

    private Document() {
    }

    /*
     * WARNING - void declaration
     */
    public static Segment parse(ManualDefinitionImpl manual, Iterable<String> document) {
        void var4_7;
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        for (String string : document) {
            segments.add(new TextSegment(manual, Document.trimRight(string)));
        }
        ArrayList workSegments = new ArrayList();
        for (PatternMapping type : SEGMENT_TYPES) {
            for (Segment segment : segments) {
                segment.refine(type.pattern, type.refiner).forEach(workSegments::add);
            }
            ArrayList<TextSegment> tmp = segments;
            segments = workSegments;
            workSegments = tmp;
            workSegments.clear();
        }
        boolean bl = false;
        while (var4_7 < segments.size() - 1) {
            ((Segment)segments.get((int)var4_7)).setNext((Segment)segments.get((int)(var4_7 + true)));
            ++var4_7;
        }
        return segments.size() > 0 ? (Segment)segments.get(0) : new TextSegment(manual, "");
    }

    public static int height(Segment document, int maxWidth, FontRenderer renderer) {
        int currentX = 0;
        int currentY = 0;
        for (Segment segment = document; segment != null; segment = segment.next()) {
            currentY += segment.nextY(currentX, maxWidth, renderer);
            currentX = segment.nextX(currentX, maxWidth, renderer);
        }
        return currentY;
    }

    public static int lineHeight(FontRenderer renderer) {
        return renderer.FONT_HEIGHT + 1;
    }

    public static Optional<InteractiveSegment> render(Segment document, int x, int y, int maxWidth, int maxHeight, int yOffset, FontRenderer renderer, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.getMinecraft();
        GlStateManager.pushAttrib();
        GlStateManager.disableAlpha();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.clear((int)256);
        GlStateManager.enableDepth();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)500.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)y);
        GL11.glVertex2f((float)mc.displayWidth, (float)y);
        GL11.glVertex2f((float)mc.displayWidth, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)mc.displayHeight);
        GL11.glVertex2f((float)mc.displayWidth, (float)mc.displayHeight);
        GL11.glVertex2f((float)mc.displayWidth, (float)(y + maxHeight));
        GL11.glVertex2f((float)0.0f, (float)(y + maxHeight));
        GL11.glEnd();
        GlStateManager.popMatrix();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Optional<InteractiveSegment> hovered = Optional.empty();
        int indent = 0;
        int currentY = y - yOffset;
        int minY = y - Document.lineHeight(renderer);
        int maxY = y + maxHeight + Document.lineHeight(renderer);
        for (Segment segment = document; segment != null; segment = segment.next()) {
            int segmentHeight = segment.nextY(indent, maxWidth, renderer);
            if (currentY + segmentHeight >= minY && currentY <= maxY) {
                Optional<InteractiveSegment> result = segment.render(x, currentY, indent, maxWidth, renderer, mouseX, mouseY);
                if (!hovered.isPresent()) {
                    hovered = result;
                }
            }
            currentY += segmentHeight;
            indent = segment.nextX(indent, maxWidth, renderer);
        }
        if (mouseX < x || mouseX > x + maxWidth || mouseY < y || mouseY > y + maxHeight) {
            hovered = Optional.empty();
        }
        hovered.ifPresent(InteractiveSegment::notifyHover);
        GlStateManager.popAttrib();
        GlStateManager.bindTexture((int)0);
        return hovered;
    }

    private static String trimRight(String s) {
        for (int i = s.length(); i > 0; --i) {
            if (Character.isWhitespace(s.charAt(i - 1))) continue;
            return s.substring(0, i);
        }
        return s;
    }

    private static Segment HeaderSegment(Segment s, Matcher m) {
        return new HeaderSegment(s, m.group(2), m.group(1).length());
    }

    private static Segment CodeSegment(Segment s, Matcher m) {
        return new CodeSegment(s, m.group(2));
    }

    private static Segment LinkSegment(Segment s, Matcher m) {
        return new LinkSegment(s, m.group(1), m.group(2));
    }

    private static Segment BoldSegment(Segment s, Matcher m) {
        return new BoldSegment(s, m.group(2));
    }

    private static Segment ItalicSegment(Segment s, Matcher m) {
        return new ItalicSegment(s, m.group(2));
    }

    private static Segment StrikethroughSegment(Segment s, Matcher m) {
        return new StrikethroughSegment(s, m.group(1));
    }

    public static Segment ImageSegment(Segment s, Matcher m) {
        try {
            ImageRenderer renderer = s.getManual().imageFor(m.group(2));
            if (renderer != null) {
                return new JEIRenderSegment(s, m.group(1), m.group(2), renderer);
            }
            return new JEISegment(s, "No renderer found for: " + m.group(2));
        }
        catch (Throwable t) {
            return new TextSegment(s, Strings.isNullOrEmpty((String)t.toString()) ? "Unknown error." : t.toString());
        }
    }

    public static final class PatternMapping {
        public final Pattern pattern;
        public final SegmentRefiner refiner;

        private PatternMapping(String pattern, SegmentRefiner refiner) {
            this.pattern = Pattern.compile(pattern);
            this.refiner = refiner;
        }
    }
}

