/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.client.gui;

import betterwithmods.manual.client.manual.Document;
import betterwithmods.manual.client.manual.segment.InteractiveSegment;
import betterwithmods.manual.client.manual.segment.Segment;
import betterwithmods.manual.client.renderer.TextureLoader;
import betterwithmods.manual.common.api.ManualDefinitionImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public final class GuiManual
extends GuiScreen {
    private static final int documentMaxWidth = 220;
    private static final int documentMaxHeight = 192;
    private static final int scrollPosX = 250;
    private static final int scrollPosY = 48;
    private static final int scrollWidth = 26;
    private static final int scrollHeight = 180;
    private static final int tabPosX = -52;
    private static final int tabPosY = 40;
    private static final int tabWidth = 64;
    private static final int tabHeight = 32;
    private static final int tabOverlap = 8;
    private static final int maxTabsPerSide = 7;
    private static final int windowWidth = 256;
    private static final int windowHeight = 256;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int xSize = 0;
    private int ySize = 0;
    private boolean isDragging = false;
    private Segment document = null;
    private int documentHeight = 0;
    private Optional<InteractiveSegment> currentSegment = Optional.empty();
    private ImageButton scrollButton = null;
    private final ManualDefinitionImpl myManual;

    public GuiManual() {
        this.myManual = ManualDefinitionImpl.INSTANCE;
    }

    public GuiManual(ManualDefinitionImpl manual) {
        this.myManual = manual;
    }

    public void pushPage(String path) {
        if (!this.myManual.peekPath().equals(path)) {
            this.myManual.pushPath(path);
            this.refreshPage();
        }
    }

    public void initGui() {
        super.initGui();
        ScaledResolution screenSize = new ScaledResolution(this.mc.displayWidth, this.mc.displayHeight);
        ScaledResolution guiSize = new ScaledResolution(256, 256);
        int midX = screenSize.scaledWidth / 2;
        int midY = screenSize.scaledHeight / 2;
        this.guiLeft = midX - guiSize.scaledWidth / 2;
        this.guiTop = midY - guiSize.scaledHeight / 2;
        this.xSize = guiSize.scaledWidth;
        this.ySize = guiSize.scaledHeight;
        for (int i = 0; i < this.myManual.getTabs().size() && i < 7; ++i) {
            int x = this.guiLeft + -52;
            int y = this.guiTop + 40 + i * 24;
            this.buttonList.add(new ImageButton(i, x, y, 64, 23, TextureLoader.LOCATION_MANUAL_TAB).setImageHeight(32).setVerticalImageOffset(-4));
        }
        this.scrollButton = new ImageButton(-1, this.guiLeft + 250, this.guiTop + 48, 26, 13, TextureLoader.LOCATION_MANUAL_SCROLL);
        this.buttonList.add(this.scrollButton);
        this.refreshPage();
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        ImageButton button;
        ManualDefinitionImpl.Tab tab;
        int i;
        GlStateManager.enableBlend();
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.mc.renderEngine.bindTexture(TextureLoader.LOCATION_MANUAL_BACKGROUND);
        Gui.drawModalRectWithCustomSizedTexture((int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (float)256.0f, (float)256.0f);
        this.scrollButton.enabled = this.canScroll();
        this.scrollButton.hoverOverride = this.isDragging;
        for (i = 0; i < this.myManual.getTabs().size() && i < 7; ++i) {
            tab = this.myManual.getTabs().get(i);
            button = (ImageButton)((Object)this.buttonList.get(i));
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)(button.x + 30), (float)(button.y + 4 - 4), (float)this.zLevel);
            tab.renderer.render();
            GlStateManager.popMatrix();
        }
        this.currentSegment = Document.render(this.document, this.guiLeft + 16, this.guiTop + 32, 220, 192, this.offset(), this.getFontRenderer(), mouseX, mouseY);
        if (!this.isDragging) {
            this.currentSegment.ifPresent(s -> s.tooltip().ifPresent(t -> this.drawHoveringText(Collections.singletonList(I18n.format((String)t, (Object[])new Object[0])), mouseX, mouseY, this.getFontRenderer())));
            for (i = 0; i < this.myManual.getTabs().size() && i < 7; ++i) {
                tab = this.myManual.getTabs().get(i);
                button = (ImageButton)((Object)this.buttonList.get(i));
                if (mouseX <= button.x || mouseX >= button.x + button.width || mouseY <= button.y || mouseY >= button.y + button.height || tab.tooltip == null) continue;
                this.drawHoveringText(Collections.singletonList(I18n.format((String)tab.tooltip, (Object[])new Object[0])), mouseX, mouseY, this.getFontRenderer());
            }
        }
        if (this.canScroll() && (this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop) || this.isDragging)) {
            this.drawHoveringText(Collections.singletonList(100 * this.offset() / this.maxOffset() + "%"), this.guiLeft + 250 + 26, this.scrollButton.y + this.scrollButton.height + 1, this.getFontRenderer());
        }
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        if (Mouse.hasWheel() && Mouse.getEventDWheel() != 0) {
            if (Math.signum(Mouse.getEventDWheel()) < 0.0f) {
                this.scrollDown();
            } else {
                this.scrollUp();
            }
        }
    }

    protected void keyTyped(char ch, int code) throws IOException {
        if (code == this.mc.gameSettings.keyBindJump.getKeyCode()) {
            this.popPage();
        } else if (code == this.mc.gameSettings.keyBindInventory.getKeyCode()) {
            this.mc.player.closeScreen();
        } else {
            super.keyTyped(ch, code);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int button) throws IOException {
        super.mouseClicked(mouseX, mouseY, button);
        if (this.canScroll() && button == 0 && this.isCoordinateOverScrollBar(mouseX - this.guiLeft, mouseY - this.guiTop)) {
            this.isDragging = true;
            this.scrollMouse(mouseY);
        } else if (button == 0) {
            this.currentSegment.ifPresent(s -> s.onMouseClick(mouseX, mouseY));
        } else if (button == 1) {
            this.popPage();
        }
    }

    protected void mouseClickMove(int mouseX, int mouseY, int lastButtonClicked, long timeSinceMouseClick) {
        super.mouseClickMove(mouseX, mouseY, lastButtonClicked, timeSinceMouseClick);
        if (this.isDragging) {
            this.scrollMouse(mouseY);
        }
    }

    protected void mouseReleased(int mouseX, int mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        if (button == 0) {
            this.isDragging = false;
        }
    }

    protected void actionPerformed(GuiButton button) throws IOException {
        if (button.id >= 0 && button.id < this.myManual.getTabs().size()) {
            this.myManual.navigate(this.myManual.getTabs().get((int)button.id).path);
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    private FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    private boolean canScroll() {
        return this.maxOffset() > 0;
    }

    private int offset() {
        return this.myManual.peekOffset();
    }

    private int maxOffset() {
        return this.documentHeight - 192;
    }

    private void refreshPage() {
        String language = FMLCommonHandler.instance().getCurrentLanguage();
        Iterable<String> content = this.myManual.contentFor(this.myManual.peekPath());
        this.document = Document.parse(this.myManual, content != null ? content : Collections.singletonList("Document not found: " + ManualDefinitionImpl.PATTERN_LANGUAGE_KEY.matcher(this.myManual.peekPath()).replaceAll(language)));
        this.documentHeight = Document.height(this.document, 220, this.getFontRenderer());
        this.scrollTo(this.offset());
    }

    private void popPage() {
        if (this.myManual.getHistorySize() > 1) {
            this.myManual.popPath();
            this.refreshPage();
        } else {
            Minecraft.getMinecraft().player.closeScreen();
        }
    }

    private void scrollMouse(int mouseY) {
        this.scrollTo((int)Math.round(((double)(mouseY - this.guiTop - 48) - 6.5) * (double)this.maxOffset() / 167.0));
    }

    private void scrollUp() {
        this.scrollTo(this.offset() - Document.lineHeight(this.getFontRenderer()) * 3);
    }

    private void scrollDown() {
        this.scrollTo(this.offset() + Document.lineHeight(this.getFontRenderer()) * 3);
    }

    private void scrollTo(int row) {
        this.myManual.setOffset(Math.max(0, Math.min(this.maxOffset(), row)));
        int yMin = this.guiTop + 48;
        this.scrollButton.y = this.maxOffset() > 0 ? yMin + 167 * this.offset() / this.maxOffset() : yMin;
    }

    private boolean isCoordinateOverScrollBar(int x, int y) {
        return x > 250 && x < 276 && y >= 48 && y < 228;
    }

    private static class ScaledResolution {
        public final int scaledWidth;
        public final int scaledHeight;

        public ScaledResolution(int width, int height) {
            int scaleFactor = 1;
            int guiScale = Minecraft.getMinecraft().gameSettings.guiScale;
            if (guiScale == 0) {
                guiScale = 1000;
            }
            while (scaleFactor < guiScale && width / (scaleFactor + 1) >= 320 && height / (scaleFactor + 1) >= 240) {
                ++scaleFactor;
            }
            if (Minecraft.getMinecraft().isUnicode() && scaleFactor % 2 != 0 && scaleFactor != 1) {
                --scaleFactor;
            }
            this.scaledWidth = MathHelper.ceil((double)((double)width / (double)scaleFactor));
            this.scaledHeight = MathHelper.ceil((double)((double)height / (double)scaleFactor));
        }
    }

    private static class ImageButton
    extends GuiButton {
        private final ResourceLocation image;
        private boolean hoverOverride = false;
        private int verticalImageOffset = 0;
        private int imageHeightOverride = 0;

        public ImageButton(int id, int x, int y, int w, int h, ResourceLocation image) {
            super(id, x, y, w, h, "");
            this.image = image;
        }

        public ImageButton setImageHeight(int height) {
            this.imageHeightOverride = height;
            return this;
        }

        public ImageButton setVerticalImageOffset(int offset) {
            this.verticalImageOffset = offset;
            return this;
        }

        public void drawButton(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                mc.getTextureManager().bindTexture(this.image);
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                int x0 = this.x;
                int x1 = this.x + this.width;
                int y0 = this.y + this.verticalImageOffset;
                int y1 = this.y + this.verticalImageOffset + (this.imageHeightOverride > 0 ? this.imageHeightOverride : this.height);
                double u0 = 0.0;
                double u1 = 1.0;
                double v0 = this.hoverOverride || this.getHoverState(this.hovered) == 2 ? 0.5 : 0.0;
                double v1 = v0 + 0.5;
                Tessellator t = Tessellator.getInstance();
                BufferBuilder b = t.getBuffer();
                b.begin(7, DefaultVertexFormats.POSITION_TEX);
                b.pos((double)x0, (double)y1, (double)this.zLevel).tex(0.0, v1).endVertex();
                b.pos((double)x1, (double)y1, (double)this.zLevel).tex(1.0, v1).endVertex();
                b.pos((double)x1, (double)y0, (double)this.zLevel).tex(1.0, v0).endVertex();
                b.pos((double)x0, (double)y0, (double)this.zLevel).tex(0.0, v0).endVertex();
                t.draw();
            }
        }
    }
}

