/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.manual.api.util;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class RenderUtil {
    @SideOnly(value=Side.CLIENT)
    public static void bindTexture(ResourceLocation location) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(location);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static TextureAtlasSprite getSprite(ResourceLocation location) {
        return Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(location.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawUntexturedQuad(float x, float y, float w, float h) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION);
        buffer.pos((double)x, (double)(y + h), 0.0).endVertex();
        buffer.pos((double)(x + w), (double)(y + h), 0.0).endVertex();
        buffer.pos((double)(x + w), (double)y, 0.0).endVertex();
        buffer.pos((double)x, (double)y, 0.0).endVertex();
        tessellator.draw();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuad(float x, float y, float w, float h, float u0, float v0, float u1, float v1) {
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        buffer.pos((double)x, (double)(y + h), 0.0).tex((double)u0, (double)v1).endVertex();
        buffer.pos((double)(x + w), (double)(y + h), 0.0).tex((double)u1, (double)v1).endVertex();
        buffer.pos((double)(x + w), (double)y, 0.0).tex((double)u1, (double)v0).endVertex();
        buffer.pos((double)x, (double)y, 0.0).tex((double)u0, (double)v0).endVertex();
        tessellator.draw();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuad(float u0, float v0, float u1, float v1) {
        RenderUtil.drawQuad(0.0f, 0.0f, 1.0f, 1.0f, u0, v0, u1, v1);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuad() {
        RenderUtil.drawQuad(0.0f, 0.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuad(TextureAtlasSprite sprite, float x, float y, float w, float h, float u0, float v0, float u1, float v1) {
        RenderUtil.drawQuad(x, y, w, h, sprite.getInterpolatedU((double)(u0 * 16.0f)), sprite.getInterpolatedV((double)(v0 * 16.0f)), sprite.getInterpolatedU((double)(u1 * 16.0f)), sprite.getInterpolatedV((double)(v1 * 16.0f)));
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuad(TextureAtlasSprite sprite, float u0, float v0, float u1, float v1) {
        RenderUtil.drawQuad(sprite, 0.0f, 0.0f, 1.0f, 1.0f, u0, v0, u1, v1);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuad(TextureAtlasSprite sprite) {
        RenderUtil.drawQuad(sprite, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void ignoreLighting() {
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
    }

    private RenderUtil() {
    }
}

