/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.BWRegistry;
import betterwithmods.common.BWSounds;
import betterwithmods.util.player.PlayerHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PenaltyEventHandler {
    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && !BWRegistry.PENALTY_HANDLERS.canJump(player = (EntityPlayer)event.getEntityLiving())) {
            event.getEntityLiving().motionX = 0.0;
            event.getEntityLiving().motionY = 0.0;
            event.getEntityLiving().motionZ = 0.0;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (!PlayerHelper.isSurvival(player)) {
            return;
        }
        if (!BWRegistry.PENALTY_HANDLERS.canSprint(player)) {
            player.setSprinting(false);
        }
        if (player.isInWater() && !BWRegistry.PENALTY_HANDLERS.canSwim(player) && !PlayerHelper.isNearBottom(player)) {
            player.motionY -= 0.04;
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!PlayerHelper.isSurvival(player)) {
                return;
            }
            double speed = BWRegistry.PENALTY_HANDLERS.getSpeedModifier(player);
            if (speed != 0.0) {
                PlayerHelper.changeSpeed((EntityLivingBase)player, "Penalty Speed Modifier", speed, PlayerHelper.PENALTY_SPEED_UUID);
            }
            if (BWRegistry.PENALTY_HANDLERS.inPain(player) && PlayerHelper.isMoving(player) && player.world.getWorldTime() % 60L == 0L) {
                player.playSound(BWSounds.OOF, 0.75f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getSource().getTrueSource() instanceof EntityPlayer && PlayerHelper.isSurvival(player = (EntityPlayer)event.getSource().getTrueSource()) && !BWRegistry.PENALTY_HANDLERS.canAttack(player)) {
            player.playSound(BWSounds.OOF, 0.75f, 1.0f);
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }
}

