/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.common.items.ItemMaterial;
import betterwithmods.module.gameplay.Gameplay;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class BlastingOilEvent {
    private static final HashMap<EntityItem, Double> highestPoint = Maps.newHashMap();

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingHurtEvent e) {
        IItemHandler inventory;
        if (Gameplay.disableBlastingOilEvents) {
            return;
        }
        if (Gameplay.blacklistDamageSources.contains(e.getSource().damageType)) {
            return;
        }
        DamageSource BLAST_OIL = new DamageSource("blastingoil");
        EntityLivingBase living = e.getEntityLiving();
        if (living.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (inventory = (IItemHandler)living.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            int count = 0;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.isEmpty() || !stack.isItemEqual(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL))) continue;
                count += stack.getCount();
                inventory.extractItem(i, stack.getCount(), false);
            }
            if (count > 0) {
                living.attackEntityFrom(BLAST_OIL, Float.MAX_VALUE);
                living.getEntityWorld().createExplosion(null, living.posX, living.posY + (double)(living.height / 16.0f), living.posZ, (float)(Math.sqrt(count / 5) / 2.5 + 1.0), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onHitGround(TickEvent.WorldTickEvent event) {
        List<EntityItem> items;
        if (Gameplay.disableBlastingOilEvents) {
            return;
        }
        World world = event.world;
        if (world.isRemote || event.phase != TickEvent.Phase.END) {
            return;
        }
        List list = world.loadedEntityList;
        synchronized (list) {
            items = world.loadedEntityList.stream().filter(e -> e instanceof EntityItem && ((EntityItem)e).getItem().isItemEqual(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BLASTING_OIL))).map(e -> (EntityItem)e).collect(Collectors.toList());
        }
        HashSet toRemove = new HashSet();
        items.forEach(item -> {
            int count;
            boolean ground = item.onGround;
            if ((item.isBurning() || ground && Math.abs(item.posY - highestPoint.getOrDefault(item, item.posY)) > 2.0) && (count = item.getItem().getCount()) > 0) {
                world.createExplosion((Entity)item, item.posX, item.posY + (double)(item.height / 16.0f), item.posZ, (float)(Math.sqrt(count / 5) / 2.5 + 1.0), true);
                toRemove.add(item);
                item.setDead();
            }
            if (item.motionY > 0.0 || !highestPoint.containsKey(item)) {
                highestPoint.put((EntityItem)item, item.posY);
            }
        });
        toRemove.forEach(highestPoint::remove);
    }
}

