/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.world.gen.feature;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBloodLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenBloodTree
extends WorldGenAbstractTree {
    private IBlockState log = BWMBlocks.BLOOD_LOG.getDefaultState();
    private IBlockState leaves = BWMBlocks.BLOOD_LEAVES.getDefaultState().withProperty((IProperty)BlockLeaves.DECAYABLE, (Comparable)Boolean.valueOf(true));

    public WorldGenBloodTree() {
        super(true);
    }

    public boolean generate(World world, Random rand, BlockPos pos) {
        int height = 5 + rand.nextInt(4);
        boolean flag = true;
        if (pos.getY() >= 1 && pos.getY() + height + 1 <= 256) {
            for (int i = pos.getY(); i <= pos.getY() + height + 1; ++i) {
                int range = i == pos.getY() ? 0 : (i <= pos.getY() + 1 + height - 2 ? 2 : 1);
                BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
                for (int x = pos.getX() - range; x <= pos.getX() + range && flag; ++x) {
                    for (int z = pos.getZ() - range; z <= pos.getZ() + range && flag; ++z) {
                        if (i >= 0 && i < world.getHeight()) {
                            if (this.isReplaceable(world, (BlockPos)mut.setPos(x, i, z))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            boolean isSustained = world.getBlockState(pos.down()).getBlock().canSustainPlant(world.getBlockState(pos.down()), (IBlockAccess)world, pos.down(), EnumFacing.UP, (IPlantable)BWMBlocks.BLOOD_SAPLING);
            if (isSustained && pos.getY() < world.getHeight() - height - 1) {
                int y;
                world.getBlockState(pos.down()).getBlock().onPlantGrow(world.getBlockState(pos.down()), world, pos.down(), pos);
                for (y = pos.getY() - 3 + height; y <= pos.getY() + height; ++y) {
                    int w = y - (pos.getY() + height);
                    int width = 1 - w / 2;
                    for (int x = pos.getX() - width; x <= pos.getX() + width; ++x) {
                        int xWide = x - pos.getX();
                        for (int z = pos.getZ() - width; z <= pos.getZ() + width; ++z) {
                            BlockPos leafPos;
                            IBlockState leafState;
                            int zWide = z - pos.getZ();
                            if (Math.abs(xWide) == width && Math.abs(zWide) == width && (rand.nextInt(2) == 0 || w == 0) || !(leafState = world.getBlockState(leafPos = new BlockPos(x, y, z))).getBlock().isAir(leafState, (IBlockAccess)world, leafPos)) continue;
                            this.setBlockAndNotifyAdequately(world, leafPos, this.leaves);
                        }
                    }
                }
                for (y = 0; y < height; ++y) {
                    BlockPos up = pos.up(y);
                    IBlockState logState = world.getBlockState(up);
                    if (!logState.getBlock().isAir(logState, (IBlockAccess)world, up) && !logState.getBlock().isLeaves(logState, (IBlockAccess)world, up)) continue;
                    if (y > height - 4) {
                        this.setBlockAndNotifyAdequately(world, up, this.log.withProperty((IProperty)BlockBloodLog.EXPANDABLE, (Comparable)Boolean.valueOf(world.provider.isNether())));
                        int face = rand.nextInt(6);
                        if (face <= 1) continue;
                        EnumFacing facing = EnumFacing.getFront((int)face);
                        for (int i = 0; i < 1 + rand.nextInt(2); ++i) {
                            this.generateBranch(world, up.offset(facing, i), facing);
                        }
                        continue;
                    }
                    this.setBlockAndNotifyAdequately(world, up, this.log);
                }
                return true;
            }
        }
        return false;
    }

    public void generateBranch(World world, BlockPos pos, EnumFacing facing) {
        if (this.isReplaceable(world, pos)) {
            BlockPos check = pos.offset(facing);
            IBlockState checkState = world.getBlockState(check);
            if (this.canOverwrite(checkState, world, check)) {
                world.setBlockState(check, this.log.withProperty((IProperty)BlockBloodLog.EXPANDABLE, (Comparable)Boolean.valueOf(world.provider.isNether())).withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.fromFacingAxis((EnumFacing.Axis)facing.getAxis())));
            }
            this.generateLeafExpansion(world, check, facing.getAxis());
            this.generateLeafExpansion(world, check.offset(facing), facing.getAxis());
        }
    }

    private void generateLeafExpansion(World world, BlockPos pos, EnumFacing.Axis axis) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                BlockPos offset = axis == EnumFacing.Axis.X ? pos.add(0, i, j) : (axis == EnumFacing.Axis.Y ? pos.add(i, 0, j) : pos.add(i, j, 0));
                if (!this.canOverwrite(world.getBlockState(offset), world, offset)) continue;
                world.setBlockState(offset, this.leaves);
            }
        }
    }

    public boolean canGrowInto(Block block) {
        return super.canGrowInto(block) || block == BWMBlocks.BLOOD_LOG;
    }

    private boolean canOverwrite(IBlockState state, World world, BlockPos pos) {
        Block block = state.getBlock();
        return block.isReplaceable((IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos);
    }
}

