/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.crafting;

import betterwithmods.common.registry.crafting.ToolBaseRecipe;
import betterwithmods.module.hardcore.crafting.HCFishing;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class BaitingRecipe
extends ToolBaseRecipe {
    public BaitingRecipe() {
        super(new ResourceLocation("betterwithmods", "baiting_recipe"), ItemStack.EMPTY, HCFishing.BAIT, stack -> HCFishing.isBaited(stack, false));
        this.setRegistryName(this.getGroup());
    }

    public ItemStack findRod(InventoryCrafting inv) {
        for (int x = 0; x < inv.getSizeInventory(); ++x) {
            ItemStack slot = inv.getStackInSlot(x);
            if (!this.isTool.test(slot)) continue;
            return slot;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting inv) {
        NonNullList ret = NonNullList.withSize((int)inv.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)inv.getStackInSlot(i)));
        }
        return ret;
    }

    @Override
    public void playSound(InventoryCrafting inv) {
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public Pair<Float, Float> getSoundValues() {
        return null;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack rod = this.findRod(inv);
        if (!rod.isEmpty()) {
            return HCFishing.setBaited(rod.copy(), true);
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack getRecipeOutput() {
        ItemStack rod = new ItemStack((Item)Items.FISHING_ROD);
        if (!rod.isEmpty()) {
            return HCFishing.setBaited(rod.copy(), true);
        }
        return ItemStack.EMPTY;
    }

    public boolean isDynamic() {
        return true;
    }

    @Override
    public ItemStack getExampleStack() {
        return new ItemStack((Item)Items.FISHING_ROD);
    }
}

