/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.recipes;

import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.ItemStackHandler;

public class BulkCraftEvent
extends Event {
    private TileEntity tile;
    private World world;
    private ItemStackHandler inventory;
    private BulkRecipe recipe;
    private NonNullList<ItemStack> outputs;

    public BulkCraftEvent(TileEntity tile, World world, ItemStackHandler inventory, BulkRecipe recipe, NonNullList<ItemStack> outputs) {
        this.tile = tile;
        this.world = world;
        this.inventory = inventory;
        this.recipe = recipe;
        this.outputs = outputs;
    }

    public boolean isCancelable() {
        return true;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public World getWorld() {
        return this.world;
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public BulkRecipe getRecipe() {
        return this.recipe;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.outputs;
    }

    public static NonNullList<ItemStack> fireOnCraft(TileEntity tile, World world, ItemStackHandler inventory, BulkRecipe recipe, NonNullList<ItemStack> outputs) {
        BulkCraftEvent event = new BulkCraftEvent(tile, world, inventory, recipe, outputs);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return NonNullList.create();
        }
        return outputs;
    }
}

