/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.bulk.manager;

import betterwithmods.common.BWRegistry;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.mechanical.tile.TileEntityMill;
import betterwithmods.common.registry.bulk.manager.CraftingManagerBulk;
import betterwithmods.common.registry.bulk.recipes.MillRecipe;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class MillManager
extends CraftingManagerBulk<MillRecipe> {
    public MillRecipe addMillRecipe(List<Ingredient> inputs, List<ItemStack> outputs, SoundEvent type) {
        return this.addRecipe(new MillRecipe(inputs, outputs).setSound(type));
    }

    public MillRecipe addMillRecipe(List<Ingredient> inputs, List<ItemStack> outputs) {
        return this.addRecipe(new MillRecipe(inputs, outputs));
    }

    public MillRecipe addMillRecipe(Ingredient input, List<ItemStack> outputs, SoundEvent type) {
        return this.addMillRecipe(Lists.newArrayList((Object[])new Ingredient[]{input}), outputs, type);
    }

    public MillRecipe addMillRecipe(Ingredient input, ItemStack output, SoundEvent type) {
        return this.addMillRecipe(Lists.newArrayList((Object[])new Ingredient[]{input}), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}), type);
    }

    public MillRecipe addMillRecipe(ItemStack input, List<ItemStack> outputs, SoundEvent type) {
        return this.addMillRecipe((Ingredient)StackIngredient.fromStacks(input), outputs, type);
    }

    public MillRecipe addMillRecipe(ItemStack input, ItemStack output, SoundEvent type) {
        return this.addMillRecipe((Ingredient)StackIngredient.fromStacks(input), output, type);
    }

    public MillRecipe addMillRecipe(Ingredient input, List<ItemStack> outputs) {
        return this.addMillRecipe(Lists.newArrayList((Object[])new Ingredient[]{input}), outputs);
    }

    public MillRecipe addMillRecipe(Ingredient input, ItemStack output) {
        return this.addMillRecipe(Lists.newArrayList((Object[])new Ingredient[]{input}), (List<ItemStack>)Lists.newArrayList((Object[])new ItemStack[]{output}));
    }

    public MillRecipe addMillRecipe(ItemStack input, List<ItemStack> outputs) {
        return this.addMillRecipe((Ingredient)StackIngredient.fromStacks(input), outputs);
    }

    public MillRecipe addMillRecipe(ItemStack input, ItemStack output) {
        return this.addMillRecipe((Ingredient)StackIngredient.fromStacks(input), output);
    }

    @Override
    public boolean canCraft(MillRecipe recipe, TileEntity tile, ItemStackHandler inv) {
        if (recipe != null && tile instanceof TileEntityMill) {
            TileEntityMill mill = (TileEntityMill)tile;
            return mill.grindCounter >= recipe.getTicks();
        }
        return false;
    }

    @Override
    public boolean craftRecipe(World world, TileEntity tile, ItemStackHandler inv) {
        if (tile instanceof TileEntityMill) {
            TileEntityMill mill = (TileEntityMill)tile;
            MillRecipe recipe = this.findRecipe(this.recipes, tile, inv).orElse(null);
            if (mill.getBlockWorld().rand.nextInt(20) == 0) {
                mill.getBlockWorld().playSound(null, mill.getBlockPos(), BWSounds.STONEGRIND, SoundCategory.BLOCKS, 0.5f + mill.getBlockWorld().rand.nextFloat() * 0.1f, 0.5f + mill.getBlockWorld().rand.nextFloat() * 0.1f);
            }
            if (recipe != null) {
                if (mill.grindMax != recipe.getTicks()) {
                    mill.grindMax = recipe.getTicks();
                }
                if (mill.getBlockWorld().rand.nextInt(40) < 2) {
                    mill.getBlockWorld().playSound(null, mill.getBlockPos(), recipe.getSound(), SoundCategory.BLOCKS, 0.75f, mill.getWorld().rand.nextFloat() * 0.4f + 0.8f);
                }
                if (this.canCraft(recipe, tile, inv)) {
                    mill.ejectRecipe(BWRegistry.MILLSTONE.craftItem(recipe, world, tile, inv));
                    mill.grindCounter = 0;
                    return true;
                }
                mill.grindCounter = Math.min(mill.grindMax, mill.grindCounter + mill.getIncrement());
                mill.markDirty();
            } else {
                mill.grindCounter = 0;
                mill.grindMax = -1;
            }
        }
        return false;
    }
}

