/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.block.recipe;

import betterwithmods.api.tile.IHeatRecipe;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.BlockRecipe;
import betterwithmods.event.FakePlayerHandler;
import betterwithmods.util.InvUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class KilnRecipe
extends BlockRecipe
implements IHeatRecipe {
    private int heat;
    private boolean ignoreHeat;

    public KilnRecipe(BlockIngredient input, List<ItemStack> outputs, int heat) {
        super(input, outputs);
        this.heat = heat;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public boolean ignore() {
        return this.ignoreHeat;
    }

    public KilnRecipe setIgnoreHeat(boolean ignoreHeat) {
        this.ignoreHeat = ignoreHeat;
        return this;
    }

    @Override
    public boolean craftRecipe(World world, BlockPos pos, Random rand, IBlockState state) {
        InvUtils.ejectStackWithOffset(world, pos, this.onCraft(world, pos));
        state.getBlock().onBlockHarvested(world, pos, state, (EntityPlayer)FakePlayerHandler.getPlayer());
        world.setBlockState(pos, Blocks.AIR.getDefaultState(), world.isRemote ? 11 : 3);
        return true;
    }

    @Override
    public boolean matches(World world, BlockPos pos, IBlockState state) {
        if (super.matches(world, pos, state)) {
            if (!this.ignore()) {
                int heat = KilnStructureManager.getHeat(world, pos.down());
                return heat == this.getHeat();
            }
            return true;
        }
        return false;
    }
}

