/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.block.recipe;

import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.recipe.impl.ListOutputs;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.util.InvUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockRecipe {
    private final BlockIngredient input;
    private final IRecipeOutputs recipeOutput;

    public BlockRecipe(BlockIngredient input, List<ItemStack> outputs) {
        this(input, new ListOutputs(outputs));
    }

    public BlockRecipe(BlockIngredient input, IRecipeOutputs recipeOutput) {
        this.input = input;
        this.recipeOutput = recipeOutput;
    }

    public abstract boolean craftRecipe(World var1, BlockPos var2, Random var3, IBlockState var4);

    public NonNullList<ItemStack> onCraft(World world, BlockPos pos) {
        NonNullList items = NonNullList.create();
        if (this.consumeIngredients(world, pos)) {
            items.addAll(this.getOutputs());
        }
        return items;
    }

    public boolean consumeIngredients(World world, BlockPos pos) {
        return world.setBlockToAir(pos);
    }

    public BlockIngredient getInput() {
        return this.input;
    }

    public IRecipeOutputs getRecipeOutput() {
        return this.recipeOutput;
    }

    public NonNullList<ItemStack> getOutputs() {
        return this.recipeOutput.getOutputs();
    }

    public String toString() {
        return String.format("%s-> %s", new Object[]{this.input, this.getOutputs()});
    }

    public boolean isInvalid() {
        return this.input.isSimple() && InvUtils.isIngredientValid(this.input) || this.recipeOutput.isInvalid();
    }

    public boolean matches(World world, BlockPos pos, IBlockState state) {
        return this.getInput().apply(world, pos, state);
    }

    public boolean isHidden() {
        return false;
    }
}

