/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.block.managers;

import betterwithmods.common.BWMRecipes;
import betterwithmods.common.blocks.mechanical.tile.TileEntityTurntable;
import betterwithmods.common.registry.block.managers.CraftingManagerBlock;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.TurntableRecipe;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TurntableManagerBlock
extends CraftingManagerBlock<TurntableRecipe> {
    public TurntableRecipe addDefaultRecipe(ItemStack input, ItemStack productState) {
        return this.addDefaultRecipe(new BlockIngredient(input), BWMRecipes.getStateFromStack(productState), (List<ItemStack>)Lists.newArrayList());
    }

    public TurntableRecipe addDefaultRecipe(ItemStack input, ItemStack productState, List<ItemStack> outputs) {
        return this.addDefaultRecipe(new BlockIngredient(input), BWMRecipes.getStateFromStack(productState), outputs);
    }

    public TurntableRecipe addDefaultRecipe(ItemStack input, IBlockState productState, List<ItemStack> outputs) {
        return this.addDefaultRecipe(new BlockIngredient(input), productState, outputs);
    }

    public TurntableRecipe addDefaultRecipe(BlockIngredient input, IBlockState productState, List<ItemStack> outputs) {
        return this.addRecipe(input, productState, outputs, 8);
    }

    public TurntableRecipe addRecipe(BlockIngredient input, IBlockState productState, List<ItemStack> outputs, int rotations) {
        return this.addRecipe(new TurntableRecipe(input, productState, outputs, rotations));
    }

    protected List<TurntableRecipe> findRecipe(IBlockState output) {
        return this.recipes.stream().filter(r -> r.getProductState() == output).collect(Collectors.toList());
    }

    @Override
    public boolean remove(IBlockState output) {
        return this.recipes.removeAll(this.findRecipe(output));
    }

    @Override
    public TurntableRecipe addRecipe(TurntableRecipe recipe) {
        return super.addRecipe(recipe);
    }

    public static TileEntityTurntable findTurntable(World world, BlockPos craftingPos) {
        for (int i = 1; i <= 2; ++i) {
            TileEntity tile = world.getTileEntity(craftingPos.down(i));
            if (!(tile instanceof TileEntityTurntable)) continue;
            return (TileEntityTurntable)tile;
        }
        return null;
    }
}

