/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.anvil;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedAnvilRecipe
extends ShapedOreRecipe {
    public static final int MAX_CRAFT_GRID_WIDTH = 4;
    public static final int MAX_CRAFT_GRID_HEIGHT = 4;

    public ShapedAnvilRecipe(ResourceLocation group, Block result, Object ... recipe) {
        super(group, result, recipe);
    }

    public ShapedAnvilRecipe(ResourceLocation group, Item result, Object ... recipe) {
        super(group, result, recipe);
    }

    public ShapedAnvilRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        super(group, result, recipe);
    }

    public ShapedAnvilRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    public boolean matches(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        for (int x = 0; x <= 4 - this.width; ++x) {
            for (int y = 0; y <= 4 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = Ingredient.EMPTY;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width) : (Ingredient)this.input.get(subX + subY * this.width);
                }
                if (target.apply(inv.getStackInRowAndColumn(x, y))) continue;
                return false;
            }
        }
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return ShapedAnvilRecipe.factory((JsonContext)context, (JsonObject)json);
        }
    }
}

