/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.anvil;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class AnvilCraftingManager {
    public static List<IRecipe> ANVIL_CRAFTING = new ArrayList<IRecipe>();

    public static ItemStack findMatchingResult(InventoryCrafting inventory, World world) {
        for (IRecipe irecipe : ANVIL_CRAFTING) {
            if (!irecipe.matches(inventory, world)) continue;
            return irecipe.getCraftingResult(inventory);
        }
        for (IRecipe irecipe : CraftingManager.REGISTRY) {
            if (!irecipe.matches(inventory, world)) continue;
            return irecipe.getCraftingResult(inventory);
        }
        return ItemStack.EMPTY;
    }

    public static NonNullList<ItemStack> getRemainingItems(InventoryCrafting inventory, World craftMatrix) {
        for (IRecipe irecipe : ANVIL_CRAFTING) {
            if (!irecipe.matches(inventory, craftMatrix)) continue;
            return irecipe.getRemainingItems(inventory);
        }
        for (IRecipe irecipe : CraftingManager.REGISTRY) {
            if (!irecipe.matches(inventory, craftMatrix)) continue;
            return irecipe.getRemainingItems(inventory);
        }
        NonNullList nonnulllist = NonNullList.withSize((int)inventory.getSizeInventory(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)inventory.getStackInSlot(i));
        }
        return nonnulllist;
    }
}

