/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.common.BWMBlocks;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class PulleyStructureManager {
    public static Set<Predicate<IBlockState>> PULLEY_BLOCKS = new HashSet<Predicate<IBlockState>>();

    public static void registerPulleyBlock(Predicate<IBlockState> state) {
        PULLEY_BLOCKS.add(state);
    }

    public static void registerPulleyBlock(Class<? extends Block> clazz) {
        PulleyStructureManager.registerPulleyBlock((IBlockState state) -> state.getBlock().getClass().isAssignableFrom(clazz));
    }

    public static void registerPulleyBlock(IBlockState state) {
        PulleyStructureManager.registerPulleyBlock(state::equals);
    }

    public static boolean isPulleyBlock(IBlockState state) {
        return PULLEY_BLOCKS.stream().anyMatch(s -> s.test(state));
    }

    static {
        PulleyStructureManager.registerPulleyBlock(BWMBlocks.PLATFORM.getDefaultState());
        PulleyStructureManager.registerPulleyBlock(BWMBlocks.IRON_WALL.getDefaultState());
    }
}

