/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.api.tile.IHeated;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.tile.TileKiln;
import betterwithmods.common.registry.block.recipe.KilnRecipe;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class KilnStructureManager {
    public static Set<IBlockState> KILN_BLOCKS = new HashSet<IBlockState>();

    public static void registerKilnBlock(IBlockState state) {
        KILN_BLOCKS.add(state);
    }

    public static boolean isKilnBlock(IBlockState state) {
        if (state == Blocks.AIR.getDefaultState()) {
            return false;
        }
        return KILN_BLOCKS.contains(state);
    }

    public static boolean createKiln(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (!KilnStructureManager.isKilnBlock(state)) {
            return false;
        }
        if (KilnStructureManager.isValidKiln((IBlockAccess)world, pos)) {
            IBlockState kiln = BWMBlocks.KILN.getDefaultState();
            world.setBlockState(pos, kiln);
            TileEntity tile = world.getTileEntity(pos);
            if (tile instanceof TileKiln) {
                ((TileKiln)tile).setCamoState(state);
                world.notifyBlockUpdate(pos, kiln, kiln, 8);
            }
            return true;
        }
        return false;
    }

    public static int getHeat(World world, BlockPos pos) {
        return BWMHeatRegistry.getHeat(world, pos.down());
    }

    public static IHeated getKiln() {
        return KilnStructureManager::getHeat;
    }

    public static boolean isValidRecipe(World world, BlockPos pos, KilnRecipe recipe) {
        return recipe.canCraft(KilnStructureManager.getKiln(), world, pos);
    }

    public static boolean isValidKiln(IBlockAccess world, BlockPos pos) {
        int numBrick = 0;
        BlockPos center = pos.up();
        for (EnumFacing face : EnumFacing.VALUES) {
            IBlockState state;
            if (face == EnumFacing.DOWN || !KilnStructureManager.isKilnBlock(state = world.getBlockState(center.offset(face)))) continue;
            ++numBrick;
        }
        return numBrick > 2;
    }

    public static void removeKilnBlock(IBlockState state) {
        KILN_BLOCKS.remove(state);
    }
}

