/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry;

import betterwithmods.api.recipe.IRecipeOutputs;
import betterwithmods.api.recipe.impl.ListOutputs;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.blocks.mechanical.tile.TileEntityFilteredHopper;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.util.InvUtils;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class HopperInteractions {
    public static final ArrayList<HopperRecipe> RECIPES = Lists.newArrayList();

    public static List<HopperRecipe> getDisplayRecipes() {
        ArrayList display = Lists.newArrayList();
        for (HopperRecipe recipe : RECIPES) {
            display.add(recipe);
            if (!(recipe instanceof SoulUrnRecipe)) continue;
            display.add(new DummySoulUrnRecipe((SoulUrnRecipe)recipe));
        }
        return display;
    }

    public static void addHopperRecipe(HopperRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static boolean remove(List<ItemStack> outputs, List<ItemStack> secondary) {
        return RECIPES.removeAll(HopperInteractions.findRecipe(outputs, secondary));
    }

    public static boolean removeFuzzy(List<ItemStack> outputs, List<ItemStack> secondary) {
        return RECIPES.removeAll(HopperInteractions.findRecipeFuzzy(outputs, secondary));
    }

    public static boolean removeExact(List<ItemStack> outputs, List<ItemStack> secondary) {
        return RECIPES.removeAll(HopperInteractions.findRecipeExact(outputs, secondary));
    }

    public static boolean removeByInput(ItemStack input) {
        return RECIPES.removeAll(HopperInteractions.findRecipeByInput(input));
    }

    protected static List<HopperRecipe> findRecipe(List<ItemStack> outputs, List<ItemStack> secondary) {
        List<HopperRecipe> recipes = HopperInteractions.findRecipeExact(outputs, secondary);
        if (recipes.isEmpty()) {
            recipes = HopperInteractions.findRecipeFuzzy(outputs, secondary);
        }
        return recipes;
    }

    protected static List<HopperRecipe> findRecipeFuzzy(List<ItemStack> outputs, List<ItemStack> secondary) {
        return RECIPES.stream().filter(recipe -> recipe.getRecipeOutputInsert().matchesFuzzy(outputs) && recipe.getRecipeOutputWorld().matchesFuzzy(secondary)).collect(Collectors.toList());
    }

    protected static List<HopperRecipe> findRecipeExact(List<ItemStack> outputs, List<ItemStack> secondary) {
        return RECIPES.stream().filter(recipe -> recipe.getRecipeOutputInsert().matches(outputs) && recipe.getRecipeOutputWorld().matches(secondary)).collect(Collectors.toList());
    }

    protected static List<HopperRecipe> findRecipeByInput(ItemStack input) {
        return RECIPES.stream().filter(r -> r.input.apply(input)).collect(Collectors.toList());
    }

    public static boolean attemptToCraft(String filterName, World world, BlockPos pos, EntityItem input, TileEntityFilteredHopper tile) {
        for (HopperRecipe recipe : RECIPES) {
            if (!recipe.isRecipe(filterName, input) || !recipe.canCraft(world, pos)) continue;
            recipe.craft(input, world, pos, tile);
            return true;
        }
        return false;
    }

    public static class HopperRecipe {
        protected final String filterName;
        protected final Ingredient input;
        protected IRecipeOutputs recipeOutputWorld;
        protected IRecipeOutputs recipeOutputInsert;

        public HopperRecipe(String filterName, Ingredient input, ItemStack output, ItemStack ... secondaryOutput) {
            this(filterName, input, Lists.newArrayList((Object[])new ItemStack[]{output}), Lists.newArrayList((Object[])secondaryOutput));
        }

        public HopperRecipe(String filterName, Ingredient input, IRecipeOutputs recipeOutputInsert, IRecipeOutputs recipeOutputWorld) {
            this.filterName = filterName;
            this.input = input;
            this.recipeOutputWorld = recipeOutputWorld;
            this.recipeOutputInsert = recipeOutputInsert;
        }

        public HopperRecipe(String filterName, Ingredient input, List<ItemStack> output, List<ItemStack> secondaryOutput) {
            this(filterName, input, new ListOutputs(output), new ListOutputs(secondaryOutput));
        }

        public boolean isRecipe(String filterName, EntityItem entity) {
            if (filterName.equals(this.filterName)) {
                if (entity != null) {
                    ItemStack stack = entity.getItem();
                    return this.input.apply(stack);
                }
                return false;
            }
            return false;
        }

        public void craft(EntityItem inputStack, World world, BlockPos pos, TileEntityFilteredHopper tile) {
            SimpleStackHandler inventory = tile.inventory;
            for (ItemStack output : this.getOutputs()) {
                ItemStack remainder = InvUtils.insert((IItemHandler)inventory, output, false);
                if (remainder.isEmpty()) continue;
                InvUtils.ejectStackWithOffset(world, inputStack.getPosition(), remainder);
            }
            InvUtils.ejectStackWithOffset(world, inputStack.getPosition(), this.getSecondaryOutputs());
            this.onCraft(world, pos, inputStack, tile);
        }

        public void onCraft(World world, BlockPos pos, EntityItem item, TileEntityFilteredHopper tile) {
            int count = this.input instanceof StackIngredient ? ((StackIngredient)this.input).getCount(item.getItem()) : 1;
            item.getItem().shrink(count);
            if (item.getItem().getCount() <= 0) {
                item.setDead();
            }
        }

        public String getFilterType() {
            return this.filterName;
        }

        public List<ItemStack> getFilters() {
            return Lists.newArrayList((Object[])BWRegistry.HOPPER_FILTERS.getFilter(this.getFilterType()).getFilter().getMatchingStacks());
        }

        public List<ItemStack> getInputContainer() {
            return Lists.newArrayList();
        }

        public List<ItemStack> getOutputContainer() {
            return Lists.newArrayList();
        }

        public Ingredient getInputs() {
            return this.input;
        }

        public List<ItemStack> getOutputs() {
            return this.recipeOutputInsert.getOutputs();
        }

        public List<ItemStack> getSecondaryOutputs() {
            return this.recipeOutputWorld.getOutputs();
        }

        public IRecipeOutputs getRecipeOutputWorld() {
            return this.recipeOutputWorld;
        }

        public IRecipeOutputs getRecipeOutputInsert() {
            return this.recipeOutputInsert;
        }

        public boolean canCraft(World world, BlockPos pos) {
            TileEntityFilteredHopper tile = (TileEntityFilteredHopper)world.getTileEntity(pos);
            if (tile != null) {
                SimpleStackHandler inventory = tile.inventory;
                List<ItemStack> outputs = this.getOutputs();
                if (outputs.isEmpty()) {
                    return true;
                }
                return outputs.stream().allMatch(stack -> InvUtils.insert((IItemHandler)inventory, stack, true).isEmpty());
            }
            return true;
        }
    }

    public static class SoulUrnRecipe
    extends HopperRecipe {
        public SoulUrnRecipe(Ingredient input, ItemStack output, ItemStack ... secondaryOutput) {
            super("betterwithmods:soul_sand", input, output, secondaryOutput);
        }

        public SoulUrnRecipe(Ingredient input, List<ItemStack> output, List<ItemStack> secondaryOutput) {
            super("betterwithmods:soul_sand", input, output, secondaryOutput);
        }

        @Override
        public void onCraft(World world, BlockPos pos, EntityItem item, TileEntityFilteredHopper tile) {
            tile.increaseSoulCount(1);
            if (!world.isRemote) {
                world.playSound(null, pos, SoundEvents.ENTITY_GHAST_AMBIENT, SoundCategory.BLOCKS, 1.0f, world.rand.nextFloat() * 0.1f + 0.45f);
            }
            super.onCraft(world, pos, item, tile);
        }
    }

    public static class DummySoulUrnRecipe
    extends SoulUrnRecipe {
        public DummySoulUrnRecipe(SoulUrnRecipe parent) {
            super((Ingredient)StackIngredient.fromIngredient(8, parent.input), parent.getOutputs(), parent.getSecondaryOutputs().stream().map(s -> InvUtils.setCount(s, 8)).collect(Collectors.toList()));
        }

        @Override
        public List<ItemStack> getInputContainer() {
            return Lists.newArrayList((Object[])new ItemStack[]{BlockUrn.getStack(BlockUrn.EnumType.EMPTY, 1)});
        }

        @Override
        public List<ItemStack> getOutputContainer() {
            return Lists.newArrayList((Object[])new ItemStack[]{BlockUrn.getStack(BlockUrn.EnumType.FULL, 1)});
        }
    }
}

