/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.common.blocks.ItemBlockMeta;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSimpleSlab
extends ItemBlockMeta {
    private final Block doubleSlab;

    public ItemSimpleSlab(Block block, Block doubleSlab) {
        super(block);
        this.doubleSlab = doubleSlab;
    }

    public EnumActionResult onItemUse(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        if (playerIn != null && (stack = playerIn.getHeldItem(hand)).getCount() != 0 && playerIn.canPlayerEdit(pos.offset(facing), facing, stack)) {
            IBlockState iblockstate = worldIn.getBlockState(pos);
            if (iblockstate.getBlock() != this.block) {
                pos = pos.offset(facing);
                iblockstate = worldIn.getBlockState(pos);
            }
            if (iblockstate.getBlock() == this.block) {
                IBlockState iblockstate1 = this.doubleSlab.getDefaultState();
                AxisAlignedBB axisalignedbb = iblockstate1.getCollisionBoundingBox((IBlockAccess)worldIn, pos);
                if (axisalignedbb != Block.NULL_AABB && worldIn.checkNoEntityCollision(axisalignedbb.offset(pos)) && worldIn.setBlockState(pos, iblockstate1, 11)) {
                    SoundType soundtype = this.doubleSlab.getSoundType(iblockstate1, worldIn, pos, (Entity)playerIn);
                    worldIn.playSound(playerIn, pos, soundtype.getPlaceSound(), SoundCategory.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    stack.shrink(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return super.onItemUse(playerIn, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        BlockPos blockpos = pos;
        IBlockState iblockstate = worldIn.getBlockState(pos);
        if (iblockstate.getBlock() == this.block && side == EnumFacing.UP) {
            return true;
        }
        IBlockState iblockstate1 = worldIn.getBlockState(pos = pos.offset(side));
        return iblockstate1.getBlock() == this.block || super.canPlaceBlockOnSide(worldIn, blockpos, side, player, stack);
    }
}

