/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.manual.api.ManualAPI;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ItemBookManual
extends ItemBook {
    public ItemBookManual() {
        this.setMaxStackSize(1);
    }

    public static boolean tryOpenManual(World world, EntityPlayer player, @Nullable String path) {
        if (path == null) {
            return false;
        }
        if (world.isRemote) {
            ManualAPI.openFor(player);
            ManualAPI.reset();
            ManualAPI.navigate(path);
        }
        return true;
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return ItemBookManual.tryOpenManual(world, player, ManualAPI.pathFor(world, pos)) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        if (world.isRemote) {
            if (player.isSneaking()) {
                ManualAPI.reset();
            }
            ManualAPI.openFor(player);
        }
        return super.onItemRightClick(world, player, hand);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.format((String)"tooltip.bwm_book.name", (Object[])new Object[0]));
        super.addInformation(stack, worldIn, tooltip, flagIn);
    }
}

