/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.common.BWMItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemArcaneScroll
extends Item {
    public static ItemStack getScrollWithEnchant(Enchantment enchantment) {
        ItemStack stack = new ItemStack(BWMItems.ARCANE_SCROLL);
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("enchant", Enchantment.getEnchantmentID((Enchantment)enchantment));
        stack.setTagCompound(tag);
        return stack;
    }

    public static Enchantment getEnchantment(ItemStack scroll) {
        NBTTagCompound tag = scroll.getTagCompound();
        if (tag.hasKey("enchant")) {
            int e = tag.getInteger("enchant");
            return Enchantment.getEnchantmentByID((int)e);
        }
        return null;
    }

    public ItemArcaneScroll() {
        this.setHasSubtypes(true);
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.isInCreativeTab(tab)) {
            for (Enchantment enchantment : Enchantment.REGISTRY) {
                items.add((Object)ItemArcaneScroll.getScrollWithEnchant(enchantment));
            }
        }
    }

    public boolean hasEffect(ItemStack stack) {
        return true;
    }

    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int id = stack.getTagCompound() != null ? stack.getTagCompound().getInteger("enchant") : 0;
        Enchantment enchantment = Enchantment.getEnchantmentByID((int)id);
        if (enchantment != null) {
            tooltip.add(enchantment.getTranslatedName(-1));
        }
    }
}

