/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.common.entity.EntitySpiderWeb;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.MathHelper;

public class ShooterSpiderWeb
extends EntityAIBase {
    private EntitySpider spider;
    private EntityLivingBase target;
    private int seeTime;
    private int attackTime;
    private int maxAttackTime;
    private float radius;
    private float maxRadius;

    public ShooterSpiderWeb(EntitySpider spider, int maxAttackTime, float radius) {
        this.spider = spider;
        this.maxAttackTime = maxAttackTime;
        this.maxRadius = this.radius = radius;
        this.setMutexBits(3);
        this.attackTime = -1;
    }

    public boolean shouldExecute() {
        EntityLivingBase target = this.spider.getAttackTarget();
        if (target != null) {
            this.target = target;
            double d = this.spider.getDistanceSq(target.posX, target.getEntityBoundingBox().minY, target.posZ);
            return !(Math.sqrt(d) < 5.0) && !target.isInWater() && !target.isInWeb;
        }
        return false;
    }

    public void updateTask() {
        double d = this.spider.getDistanceSq(this.target.posX, this.target.getEntityBoundingBox().minY, this.target.posZ);
        boolean canSee = this.spider.getEntitySenses().canSee((Entity)this.target);
        if (d <= (double)(this.maxRadius * this.maxRadius)) {
            this.spider.getNavigator().clearPath();
        } else {
            this.spider.getNavigator().tryMoveToEntityLiving((Entity)this.target, 1.0);
        }
        this.spider.getLookHelper().setLookPositionWithEntity((Entity)this.target, 30.0f, 30.0f);
        if (this.attackTime-- == 0) {
            if (canSee) {
                this.shootWeb();
            }
            float f = MathHelper.sqrt((double)d) / this.radius;
            this.attackTime = MathHelper.floor((float)(f * (float)this.maxAttackTime));
        } else if (this.attackTime < 0) {
            float f2 = MathHelper.sqrt((double)d) / this.radius;
            this.attackTime = MathHelper.floor((float)(f2 * (float)this.maxAttackTime));
        }
        super.updateTask();
    }

    public boolean shouldContinueExecuting() {
        return this.shouldExecute() || !this.spider.getNavigator().noPath();
    }

    public void resetTask() {
        this.target = null;
        this.attackTime = -1;
    }

    private void shootWeb() {
        EntitySpiderWeb web = new EntitySpiderWeb(this.spider.getEntityWorld(), (EntityLivingBase)this.spider);
        double d0 = this.target.posY;
        double d1 = this.target.posX - this.spider.posX;
        double d2 = d0 - web.posY;
        double d3 = this.target.posZ - this.spider.posZ;
        float f = MathHelper.sqrt((double)(d1 * d1 + d3 * d3)) * 0.2f;
        web.shoot(d1, d2 + (double)f, d3, 1.0f, 2.0f);
        this.spider.playSound(SoundEvents.ENTITY_SLIME_SQUISH, 1.0f, 1.0f / (this.spider.getRNG().nextFloat() * 0.4f + 0.8f));
        this.spider.world.spawnEntity((Entity)web);
    }
}

