/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.util.ReflectionLib;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class EntityAIVillagerMate
extends EntityAIBase {
    final World world;
    final double moveSpeed;
    private final EntityVillager villager;
    int spawnBabyDelay;
    private EntityVillager mate;

    public EntityAIVillagerMate(EntityVillager villager, double speedIn) {
        this.villager = villager;
        this.world = villager.getEntityWorld();
        this.moveSpeed = speedIn;
        this.setMutexBits(3);
    }

    public static boolean isWillingToMate(EntityVillager villager) {
        if (villager != null) {
            return (Boolean)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])ReflectionLib.ENTITY_VILLAGER_ISWILLINGTOMATE);
        }
        return false;
    }

    public boolean shouldExecute() {
        if (this.villager.getGrowingAge() != 0 || this.villager.getRNG().nextInt(500) != 0) {
            return false;
        }
        if (!EntityAIVillagerMate.isWillingToMate(this.villager)) {
            return false;
        }
        this.mate = this.getNearbyMate();
        return this.mate != null && this.mate.getGrowingAge() == 0;
    }

    public boolean shouldContinueExecuting() {
        return this.mate.isEntityAlive() && EntityAIVillagerMate.isWillingToMate(this.mate) && this.spawnBabyDelay < 60;
    }

    public void resetTask() {
        this.mate = null;
        this.spawnBabyDelay = 0;
    }

    public void updateTask() {
        this.villager.getLookHelper().setLookPositionWithEntity((Entity)this.mate, 10.0f, (float)this.villager.getVerticalFaceSpeed());
        this.villager.getNavigator().tryMoveToEntityLiving((Entity)this.mate, this.moveSpeed);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.villager.getDistanceSq((Entity)this.mate) < 9.0) {
            this.spawnBaby();
        }
    }

    private EntityVillager getNearbyMate() {
        List list = this.world.getEntitiesWithinAABB(this.villager.getClass(), this.villager.getEntityBoundingBox().grow(8.0));
        double d0 = Double.MAX_VALUE;
        EntityVillager mate = null;
        for (EntityVillager current : list) {
            if (!this.canMateWith(this.villager, current) || !(this.villager.getDistanceSq((Entity)current) < d0)) continue;
            mate = current;
            d0 = this.villager.getDistanceSq((Entity)current);
        }
        return mate;
    }

    private void spawnBaby() {
        EntityVillager baby = this.villager.createChild((EntityAgeable)this.mate);
        if (baby != null) {
            this.villager.setGrowingAge(6000);
            this.mate.setGrowingAge(6000);
            this.villager.setIsWillingToMate(false);
            this.mate.setIsWillingToMate(false);
            baby.setGrowingAge(-24000);
            baby.setLocationAndAngles(this.villager.posX, this.villager.posY, this.villager.posZ, 0.0f, 0.0f);
            boolean profession = this.world.rand.nextBoolean();
            baby.setProfession(profession ? this.villager.getProfessionForge() : this.mate.getProfessionForge());
            this.world.spawnEntity((Entity)baby);
            Random random = this.villager.getRNG();
            for (int i = 0; i < 7; ++i) {
                double d0 = random.nextGaussian() * 0.02;
                double d1 = random.nextGaussian() * 0.02;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextDouble() * (double)this.villager.width * 2.0 - (double)this.villager.width;
                double d4 = 0.5 + random.nextDouble() * (double)this.villager.height;
                double d5 = random.nextDouble() * (double)this.villager.width * 2.0 - (double)this.villager.width;
                this.world.spawnParticle(EnumParticleTypes.HEART, this.villager.posX + d3, this.villager.posY + d4, this.villager.posZ + d5, d0, d1, d2, new int[0]);
            }
            if (this.world.getGameRules().getBoolean("doMobLoot")) {
                this.world.spawnEntity((Entity)new EntityXPOrb(this.world, this.villager.posX, this.villager.posY, this.villager.posZ, random.nextInt(7) + 1));
            }
        }
    }

    public boolean canMateWith(EntityVillager village, EntityVillager mate) {
        return village != mate && EntityAIVillagerMate.isWillingToMate(this.villager) && EntityAIVillagerMate.isWillingToMate(mate);
    }
}

