/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.module.tweaks.EasyBreeding;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class EntityAISearchFood
extends EntityAIBase {
    private final EntityAnimal entity;
    private EntityItem targetItem;
    private int timeoutCounter;
    private double findRadius = 5.0;
    private double eatRadius = 2.0;

    public EntityAISearchFood(EntityAnimal creature) {
        this.entity = creature;
    }

    public boolean shouldExecute() {
        if (this.entity.getGrowingAge() < 1 && !this.entity.isInLove()) {
            List entityItems;
            if (this.entity instanceof EntityWolf && !((EntityWolf)this.entity).isTamed()) {
                return false;
            }
            BlockPos entityPos = this.entity.getPosition();
            if (this.targetItem == null && !(entityItems = this.entity.getEntityWorld().getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.add(1, 1, 1)).grow(this.findRadius))).isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.entity.isBreedingItem(item.getItem()) && !EasyBreeding.isOtherValidFood(item.getItem(), (EntityLivingBase)this.entity)) continue;
                    this.targetItem = item;
                    break;
                }
            }
            if (this.targetItem != null) {
                BlockPos targetPos = this.targetItem.getPosition();
                if (entityPos.getDistance(targetPos.getX(), targetPos.getY(), targetPos.getZ()) <= this.eatRadius && this.targetItem.getItem().getCount() > 0) {
                    this.processItemEating();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void startExecuting() {
        if (this.entity.getGrowingAge() < 1 && !this.entity.isInLove()) {
            if (this.entity instanceof EntityWolf && ((EntityWolf)this.entity).isSitting()) {
                return;
            }
            this.entity.getNavigator().tryMoveToXYZ(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ, 1.0);
        }
    }

    public boolean shouldContinueExecuting() {
        if (this.targetItem.isDead || this.targetItem.getItem().getCount() < 1) {
            BlockPos entityPos = this.entity.getPosition();
            List entityItems = this.entity.getEntityWorld().getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.add(1, 1, 1)).grow(this.findRadius));
            if (!entityItems.isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.entity.isBreedingItem(item.getItem())) continue;
                    this.targetItem = item;
                    break;
                }
            }
        }
        if (this.targetItem == null || this.targetItem.isDead) {
            return false;
        }
        if (this.entity.getGrowingAge() < 1 && !this.entity.isInLove()) {
            double sqDistToPos;
            if (this.entity instanceof EntityWolf && ((EntityWolf)this.entity).isSitting()) {
                return false;
            }
            if (this.timeoutCounter > 1200) {
                return false;
            }
            if (!this.entity.getNavigator().noPath() && (sqDistToPos = this.entity.getDistanceSq(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ)) > this.eatRadius) {
                return true;
            }
        }
        return false;
    }

    public void updateTask() {
        if (this.entity.getDistanceSq(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ) <= this.eatRadius && this.targetItem.getItem().getCount() > 0) {
            this.processItemEating();
        } else {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.entity.getNavigator().tryMoveToXYZ(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ, 1.0);
            }
        }
    }

    private void processItemEating() {
        if (!this.entity.getEntityWorld().isRemote) {
            ItemStack foodStack = this.targetItem.getItem();
            boolean eaten = false;
            if (this.entity.isBreedingItem(foodStack)) {
                if (this.entity.getGrowingAge() == 0 && !this.entity.isInLove()) {
                    eaten = true;
                    this.entity.setInLove(null);
                } else if (this.entity.isChild()) {
                    eaten = true;
                    this.entity.ageUp((int)((float)(-this.entity.getGrowingAge() / 20) * 0.1f), true);
                }
            }
            if (EasyBreeding.eatFood(foodStack, (EntityLivingBase)this.entity)) {
                eaten = true;
            }
            if (eaten) {
                foodStack.shrink(1);
            }
        }
    }
}

