/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;

public class EndermanAgro
extends EntityAINearestAttackableTarget<EntityPlayer> {
    public final EntityEnderman enderman;
    public EntityPlayer player;
    public int aggroTime;
    public int teleportTime;

    public EndermanAgro(EntityEnderman enderman) {
        super((EntityCreature)enderman, EntityPlayer.class, false);
        this.enderman = enderman;
    }

    public boolean shouldExecute() {
        double d0 = this.getTargetDistance();
        this.player = this.enderman.getEntityWorld().getNearestAttackablePlayer(this.enderman.posX, this.enderman.posY, this.enderman.posZ, d0, d0, null, player -> player != null && this.enderman.shouldAttackPlayer(player));
        return this.player != null;
    }

    public void startExecuting() {
        this.aggroTime = 5;
        this.teleportTime = 0;
    }

    public void resetTask() {
        this.player = null;
        super.resetTask();
    }

    public boolean shouldContinueExecuting() {
        if (this.player != null) {
            if (!this.enderman.shouldAttackPlayer(this.player)) {
                return false;
            }
            this.enderman.faceEntity((Entity)this.player, 10.0f, 10.0f);
            return true;
        }
        return this.targetEntity != null && ((EntityPlayer)this.targetEntity).isEntityAlive() || super.shouldContinueExecuting();
    }

    public void updateTask() {
        if (this.player != null) {
            if (--this.aggroTime <= 0) {
                this.targetEntity = this.player;
                this.player = null;
                super.startExecuting();
            }
        } else {
            if (this.targetEntity != null) {
                if (this.enderman.shouldAttackPlayer((EntityPlayer)this.targetEntity)) {
                    if (((EntityPlayer)this.targetEntity).getDistanceSq((Entity)this.enderman) < 16.0) {
                        this.enderman.teleportRandomly();
                    }
                    this.teleportTime = 0;
                } else if (((EntityPlayer)this.targetEntity).getDistanceSq((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.enderman.teleportToEntity((Entity)this.targetEntity)) {
                    this.teleportTime = 0;
                }
            }
            super.updateTask();
        }
    }
}

