/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai;

import betterwithmods.module.hardcore.creatures.chicken.EggLayer;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class AIFoodEggLayer
extends EntityAIBase {
    private final EntityAnimal entity;
    private final EggLayer layer;
    private EntityItem targetItem;
    private int timeoutCounter;

    public AIFoodEggLayer(EntityAnimal creature) {
        this.entity = creature;
        this.layer = (EggLayer)creature.getCapability(EggLayer.EGG_LAYER_CAP, EnumFacing.DOWN);
    }

    public boolean shouldExecute() {
        if (this.entity.getGrowingAge() < 1 && !this.layer.isFeed()) {
            List entityItems;
            BlockPos entityPos = this.entity.getPosition();
            if (this.targetItem == null && !(entityItems = this.entity.getEntityWorld().getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.add(1, 1, 1)).expand(5.0, 5.0, 5.0))).isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.layer.isBreedingItem(item.getItem())) continue;
                    this.targetItem = item;
                    break;
                }
            }
            if (this.targetItem != null) {
                BlockPos targetPos = this.targetItem.getPosition();
                if (entityPos.getDistance(targetPos.getX(), targetPos.getY(), targetPos.getZ()) <= 2.0 && this.targetItem.getItem().getCount() > 0) {
                    this.processItemEating();
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void startExecuting() {
        if (this.entity.getGrowingAge() < 1 && !this.entity.isInLove()) {
            if (this.entity instanceof EntityWolf && ((EntityWolf)this.entity).isSitting()) {
                return;
            }
            this.entity.getNavigator().tryMoveToXYZ(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ, 1.0);
        }
    }

    public boolean shouldContinueExecuting() {
        if (this.targetItem.isDead || this.targetItem.getItem().getCount() < 1) {
            BlockPos entityPos = this.entity.getPosition();
            List entityItems = this.entity.getEntityWorld().getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.add(1, 1, 1)).expand(5.0, 5.0, 5.0));
            if (!entityItems.isEmpty()) {
                for (EntityItem item : entityItems) {
                    if (!this.layer.isBreedingItem(item.getItem())) continue;
                    this.targetItem = item;
                    break;
                }
            }
        }
        if (this.targetItem == null || this.targetItem.isDead) {
            return false;
        }
        if (this.entity.getGrowingAge() < 1 && !this.layer.isFeed()) {
            double sqDistToPos;
            if (this.timeoutCounter > 1200) {
                return false;
            }
            if (!this.entity.getNavigator().noPath() && (sqDistToPos = this.entity.getDistanceSq(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ)) > 2.0) {
                return true;
            }
        }
        return false;
    }

    public void updateTask() {
        if (this.entity.getDistanceSq(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ) <= 2.0 && this.targetItem.getItem().getCount() > 0) {
            this.processItemEating();
        } else {
            ++this.timeoutCounter;
            if (this.timeoutCounter % 40 == 0) {
                this.entity.getNavigator().tryMoveToXYZ(this.targetItem.posX, this.targetItem.posY, this.targetItem.posZ, 1.0);
            }
        }
    }

    private void processItemEating() {
        if (!this.entity.getEntityWorld().isRemote) {
            ItemStack foodStack = this.targetItem.getItem().splitStack(1);
            boolean bred = false;
            if (this.layer.isBreedingItem(foodStack) && this.entity.getGrowingAge() == 0 && !this.layer.isFeed()) {
                bred = true;
                this.layer.feed((EntityLiving)this.entity, foodStack);
            }
            if (!bred) {
                this.targetItem.getItem().grow(1);
            } else if (this.targetItem.getItem().getCount() < 1) {
                this.targetItem.setDead();
            }
        }
    }
}

