/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockBloodSapling;
import betterwithmods.common.blocks.BlockNetherGrowth;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUrn
extends EntitySnowball {
    public EntityUrn(World worldIn) {
        super(worldIn);
    }

    public EntityUrn(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
    }

    public EntityUrn(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void handleStatusUpdate(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.world.spawnParticle(EnumParticleTypes.BLOCK_DUST, this.posX, this.posY, this.posZ, 0.1, 0.5, 0.1, new int[]{Block.getStateId((IBlockState)BWMBlocks.URN.getDefaultState().withProperty(BlockUrn.TYPE, (Comparable)((Object)BlockUrn.EnumType.FULL)))});
            }
        }
    }

    protected void onImpact(RayTraceResult result) {
        if (!this.world.isRemote) {
            if (result.typeOfHit != RayTraceResult.Type.MISS) {
                BlockPos pos = result.typeOfHit == RayTraceResult.Type.ENTITY ? result.entityHit.getPosition() : result.getBlockPos();
                this.world.playSound(null, this.getPosition(), SoundEvents.ENTITY_SPLASH_POTION_BREAK, SoundCategory.PLAYERS, 0.5f, 0.4f / (this.rand.nextFloat() * 0.4f + 0.8f));
                Iterable pool = BlockPos.PooledMutableBlockPos.getAllInBox((BlockPos)pos.add(-3, -3, -3), (BlockPos)pos.add(3, 3, 3));
                boolean grew = false;
                for (BlockPos p : pool) {
                    BlockBloodSapling sapling;
                    IBlockState state = this.world.getBlockState(p);
                    if (state.getBlock() == BWMBlocks.NETHER_GROWTH) {
                        BlockNetherGrowth b = (BlockNetherGrowth)state.getBlock();
                        for (int i = 0; i < 10; ++i) {
                            b.grow(this.world, p, state, this.rand);
                        }
                        grew = true;
                    }
                    if (state.getBlock() != BWMBlocks.BLOOD_SAPLING || !(sapling = (BlockBloodSapling)state.getBlock()).generateTree(this.world, p, this.world.getBlockState(p), this.rand)) continue;
                    grew = true;
                }
                if (!grew) {
                    WorldUtils.spawnGhast(this.world, pos);
                }
            }
            this.world.setEntityState((Entity)this, (byte)3);
            this.setDead();
        }
    }
}

