/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityJungleSpider
extends EntityCaveSpider {
    public static final ResourceLocation LOOT = LootTableList.register((ResourceLocation)new ResourceLocation("betterwithmods", "entity/jungle_spider"));

    public EntityJungleSpider(World worldIn) {
        super(worldIn);
    }

    public boolean attackEntityAsMob(Entity entityIn) {
        if (super.attackEntityAsMob(entityIn)) {
            if (entityIn instanceof EntityLivingBase) {
                int duration = 0;
                if (this.world.getDifficulty() == EnumDifficulty.NORMAL) {
                    duration = 7;
                } else if (this.world.getDifficulty() == EnumDifficulty.HARD) {
                    duration = 15;
                }
                if (duration > 0) {
                    ((EntityLivingBase)entityIn).addPotionEffect(new PotionEffect(MobEffects.HUNGER, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected ResourceLocation getLootTable() {
        return LOOT;
    }

    protected boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.posX, this.getEntityBoundingBox().minY, this.posZ);
        return this.world.getLightFor(EnumSkyBlock.BLOCK, blockpos) <= 7;
    }

    public boolean getCanSpawnHere() {
        BlockPos pos = new BlockPos(this.posX, this.getEntityBoundingBox().minY, this.posZ);
        BlockPos topPos = this.world.getHeight(pos).down();
        IBlockState topBlock = this.world.getBlockState(topPos);
        ArrayList<Integer> possible_spawns = this.getPossibleSpawnHeights(new BlockPos.MutableBlockPos(pos.up(32)), 32);
        if (possible_spawns.isEmpty() && topBlock.getBlock() == Blocks.LEAVES && ((Boolean)topBlock.getValue((IProperty)BlockLeaves.DECAYABLE)).booleanValue()) {
            possible_spawns = this.getPossibleSpawnHeights(new BlockPos.MutableBlockPos(topPos), 16);
        }
        if (possible_spawns.isEmpty()) {
            return false;
        }
        this.setPosition(this.posX, possible_spawns.get(this.rand.nextInt(possible_spawns.size())).intValue(), this.posZ);
        return super.getCanSpawnHere();
    }

    private ArrayList<Integer> getPossibleSpawnHeights(BlockPos.MutableBlockPos pos, int limit) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int leaves = 0;
        for (int i = 0; i < limit; ++i) {
            IBlockState state = this.world.getBlockState((BlockPos)pos);
            leaves = this.isJungleLeaves(state) ? ++leaves : 0;
            if (leaves == 2) {
                heights.add(pos.getY() + 2);
            }
            pos.move(EnumFacing.DOWN);
        }
        return heights;
    }

    private boolean isJungleLeaves(IBlockState state) {
        return state.getBlock() == Blocks.LEAVES && (Boolean)state.getValue((IProperty)BlockLeaves.DECAYABLE) != false;
    }
}

