/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.util.WorldUtils;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityHCFishHook
extends EntityFishHook
implements IEntityAdditionalSpawnData {
    public EntityHCFishHook(World world) {
        super(world, null);
    }

    public EntityHCFishHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn, fishingPlayer);
    }

    public void setDead() {
        super.setDead();
    }

    public void shoot() {
        if (this.angler == null) {
            return;
        }
        super.shoot();
    }

    public void init(EntityPlayer angler) {
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
        this.angler = angler;
        if (this.angler != null) {
            this.angler.fishEntity = this;
        }
    }

    public void catchingFish(BlockPos pos) {
        WorldServer worldserver = (WorldServer)this.world;
        double min = 1.0;
        if (WorldUtils.isTimeFrame(this.world, WorldUtils.TimeFrame.NIGHT)) {
            min *= 2.0;
        }
        if (worldserver.isRainingAt(pos.up())) {
            min *= 0.75;
        }
        if (WorldUtils.isMoonPhase(this.world, WorldUtils.MoonPhase.Full)) {
            min /= 2.0;
        }
        if (WorldUtils.isTimeFrame((World)worldserver, WorldUtils.TimeFrame.DAWN) || WorldUtils.isTimeFrame((World)worldserver, WorldUtils.TimeFrame.DUSK)) {
            min /= 2.0;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.motionY -= 0.2 * (double)this.rand.nextFloat() * (double)this.rand.nextFloat();
            }
        } else if (this.ticksCatchableDelay > 0) {
            --this.ticksCatchableDelay;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.rand.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.sin((float)f);
                float f2 = MathHelper.cos((float)f);
                double d0 = this.posX + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.floor((double)this.getEntityBoundingBox().minY) + 1.0f;
                Block block = worldserver.getBlockState(new BlockPos(d0, d1 - 1.0, d2 = this.posZ + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f))).getBlock();
                if (block == Blocks.WATER || block == Blocks.FLOWING_WATER) {
                    if (this.rand.nextFloat() < 0.15f) {
                        worldserver.spawnParticle(EnumParticleTypes.WATER_BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0, new int[0]);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    worldserver.spawnParticle(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0, new int[0]);
                    worldserver.spawnParticle(EnumParticleTypes.WATER_WAKE, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0, new int[0]);
                }
            } else {
                this.motionY = -0.4f * MathHelper.nextFloat((Random)this.rand, (float)0.6f, (float)1.0f);
                this.playSound(SoundEvents.ENTITY_BOBBER_SPLASH, 0.25f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                double d3 = this.getEntityBoundingBox().minY + 0.5;
                worldserver.spawnParticle(EnumParticleTypes.WATER_BUBBLE, this.posX, d3, this.posZ, (int)(1.0f + this.width * 20.0f), (double)this.width, 0.0, (double)this.width, (double)0.2f, new int[0]);
                worldserver.spawnParticle(EnumParticleTypes.WATER_WAKE, this.posX, d3, this.posZ, (int)(1.0f + this.width * 20.0f), (double)this.width, 0.0, (double)this.width, (double)0.2f, new int[0]);
                this.ticksCatchable = MathHelper.getInt((Random)this.rand, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            --this.ticksCaughtDelay;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.rand.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.nextFloat((Random)this.rand, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.nextFloat((Random)this.rand, (float)25.0f, (float)60.0f);
                double d4 = this.posX + (double)(MathHelper.sin((float)f6) * f7 * 0.1f);
                Block block1 = worldserver.getBlockState(new BlockPos((int)d4, (int)(d5 = (double)((float)MathHelper.floor((double)this.getEntityBoundingBox().minY) + 1.0f)) - 1, (int)(d6 = this.posZ + (double)(MathHelper.cos((float)f6) * f7 * 0.1f)))).getBlock();
                if (block1 == Blocks.WATER || block1 == Blocks.FLOWING_WATER) {
                    worldserver.spawnParticle(EnumParticleTypes.WATER_SPLASH, d4, d5, d6, 2 + this.rand.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0, new int[0]);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.nextFloat((Random)this.rand, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.getInt((Random)this.rand, (int)20, (int)80);
            }
        } else if (this.angler.isCreative()) {
            this.ticksCaughtDelay = 1;
        } else {
            int modifer = 1200;
            this.ticksCaughtDelay = MathHelper.getInt((Random)this.rand, (int)((int)(min * (double)modifer)), (int)((int)((min + 2.0) * (double)modifer)));
            this.ticksCaughtDelay = Math.max(1200, this.ticksCaughtDelay - this.lureSpeed * 1200);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.angler != null) {
            buffer.writeInt(this.angler.getEntityId());
        } else {
            buffer.writeInt(0);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.angler = (EntityPlayer)Minecraft.getMinecraft().world.getEntityByID(additionalData.readInt());
    }
}

