/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.tile.TileEntityPulley;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.AABBArray;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityExtendingRope
extends Entity
implements IEntityAdditionalSpawnData {
    private BlockPos pulley;
    private int targetY;
    private boolean up;
    private Map<Vec3i, IBlockState> blocks;
    private Map<Vec3i, NBTTagCompound> tiles;
    private AABBArray blockBB;

    public EntityExtendingRope(World worldIn) {
        this(worldIn, null, null, 0);
    }

    public EntityExtendingRope(World worldIn, BlockPos pulley, BlockPos source, int targetY) {
        super(worldIn);
        this.pulley = pulley;
        this.targetY = targetY;
        if (source != null) {
            this.up = source.getY() < targetY;
            this.setPositionAndUpdate((double)source.getX() + 0.5, source.getY(), (double)source.getZ() + 0.5);
        }
        this.blocks = Maps.newHashMap();
        this.tiles = Maps.newHashMap();
        this.blockBB = null;
        this.setSize(0.1f, 1.0f);
        this.ignoreFrustumCheck = true;
    }

    private static AxisAlignedBB createAABB(Vec3d part1, Vec3d part2) {
        return new AxisAlignedBB(part1.x, part1.y, part1.z, part2.x, part2.y, part2.z);
    }

    protected void entityInit() {
    }

    public float getEyeHeight() {
        return -1.0f;
    }

    public void setPosition(double x, double y, double z) {
        if (this.blocks != null) {
            this.updatePassengers(this.posY, y, false);
        }
        super.setPosition(x, y, z);
    }

    protected void readEntityFromNBT(NBTTagCompound compound) {
        this.pulley = new BlockPos(compound.getInteger("PulleyX"), compound.getInteger("PulleyY"), compound.getInteger("PulleyZ"));
        this.targetY = compound.getInteger("TargetY");
        this.up = compound.getBoolean("Up");
        if (compound.hasKey("BlockData")) {
            byte[] bytes = compound.getByteArray("BlockData");
            ByteBuf buf = Unpooled.buffer((int)bytes.length);
            buf.writeBytes(bytes);
            this.blocks = this.deserializeBlockmap(buf);
        }
        if (compound.hasKey("Tiles")) {
            this.tiles = this.deserializeTiles(compound.getCompoundTag("Tiles"));
        }
        this.rebuildBlockBoundingBox();
    }

    protected void writeEntityToNBT(NBTTagCompound compound) {
        compound.setInteger("PulleyX", this.pulley.getX());
        compound.setInteger("PulleyY", this.pulley.getY());
        compound.setInteger("PulleyZ", this.pulley.getZ());
        compound.setInteger("TargetY", this.targetY);
        compound.setBoolean("Up", this.up);
        ByteBuf buf = Unpooled.buffer();
        this.serializeBlockmap(buf, this.blocks);
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        compound.setByteArray("BlockData", bytes);
        NBTTagCompound t = new NBTTagCompound();
        this.serializeTiles(t, this.tiles);
        compound.setTag("Tiles", (NBTBase)t);
        if (GlobalConfig.debug) {
            for (int i = 0; i < bytes.length; ++i) {
                if (i % 16 == 0) {
                    StringBuilder text = new StringBuilder(Integer.toHexString(i));
                    while (text.length() < 8) {
                        text.insert(0, "0");
                    }
                    System.out.print("\n" + text + ": ");
                }
                StringBuilder b = new StringBuilder(Integer.toHexString(Byte.toUnsignedInt(bytes[i])));
                while (b.length() < 2) {
                    b.insert(0, "0");
                }
                System.out.print(b);
                if (i % 2 != 1) continue;
                System.out.print(' ');
            }
        }
    }

    private void serializeTiles(NBTTagCompound tag, Map<Vec3i, NBTTagCompound> tiles) {
        NBTTagList list = new NBTTagList();
        tiles.forEach((vec, tile) -> {
            NBTTagCompound entry = new NBTTagCompound();
            entry.setLong("offset", new BlockPos(vec).toLong());
            entry.setTag("tile", (NBTBase)tile);
            list.appendTag((NBTBase)entry);
        });
        tag.setTag("entries", (NBTBase)list);
    }

    private Map<Vec3i, NBTTagCompound> deserializeTiles(NBTTagCompound tag) {
        HashMap<Vec3i, NBTTagCompound> map = new HashMap<Vec3i, NBTTagCompound>();
        NBTTagList list = tag.getTagList("entries", 10);
        list.iterator().forEachRemaining(e -> {
            NBTTagCompound entry = (NBTTagCompound)e;
            BlockPos offset = BlockPos.fromLong((long)entry.getLong("offset"));
            NBTTagCompound tileData = entry.getCompoundTag("tile");
            map.put((Vec3i)offset, tileData);
        });
        return map;
    }

    private void serializeBlockmap(ByteBuf buf, Map<Vec3i, IBlockState> blocks) {
        buf.writeInt(blocks.size());
        blocks.forEach((vec, state) -> {
            buf.writeInt(vec.getX());
            buf.writeInt(vec.getY());
            buf.writeInt(vec.getZ());
            Block block = state != null ? state.getBlock() : Blocks.AIR;
            ResourceLocation resourcelocation = (ResourceLocation)Block.REGISTRY.getNameForObject((Object)block);
            String blockName = resourcelocation == null ? "" : resourcelocation.toString();
            buf.writeInt(blockName.length());
            buf.writeBytes(blockName.getBytes(Charset.forName("UTF-8")));
            buf.writeByte((int)((byte)block.getMetaFromState(state)));
        });
    }

    private Map<Vec3i, IBlockState> deserializeBlockmap(ByteBuf buf) {
        HashMap<Vec3i, IBlockState> map = new HashMap<Vec3i, IBlockState>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            Vec3i vec = new Vec3i(buf.readInt(), buf.readInt(), buf.readInt());
            int len = buf.readInt();
            byte[] bytes = new byte[len];
            buf.readBytes(bytes);
            String name = new String(bytes, Charset.forName("UTF-8"));
            byte meta = buf.readByte();
            IBlockState state = Block.getBlockFromName((String)name).getStateFromMeta((int)meta);
            map.put(vec, state);
        }
        return map;
    }

    private void rebuildBlockBoundingBox() {
        if (this.blocks == null || this.blocks.isEmpty()) {
            this.blockBB = null;
        } else {
            ArrayList<AxisAlignedBB> bbs = new ArrayList<AxisAlignedBB>();
            bbs.add(new AxisAlignedBB(0.45, 0.0, 0.45, 0.55, 1.0, 0.55));
            for (Vec3i vec : this.blocks.keySet()) {
                IBlockState state = this.blocks.get(vec);
                if (!state.getBlock().isCollidable()) continue;
                AxisAlignedBB bb2 = new AxisAlignedBB((double)vec.getX(), (double)vec.getY(), (double)vec.getZ(), (double)(vec.getX() + 1), (double)vec.getY() + this.getBlockStateHeight(state), (double)(vec.getZ() + 1));
                bbs.add(bb2);
            }
            this.blockBB = new AABBArray(bbs.toArray(new AxisAlignedBB[0])).offset(-0.5, 0.0, -0.5);
        }
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (this.up ? this.posY > (double)this.targetY && this.done() : this.posY < (double)this.targetY && this.done()) {
            return;
        }
        this.setPosition((double)this.pulley.getX() + 0.5, this.posY + (this.up ? 0.1 : -0.1), (double)this.pulley.getZ() + 0.5);
    }

    public void updatePassengers(double posY, double newPosY, boolean b) {
        HashSet entitiesInBlocks = new HashSet();
        HashSet passengers = new HashSet();
        HashMap entMaxY = new HashMap();
        this.blocks.forEach((vec, state) -> {
            if (this.getBlockStateHeight((IBlockState)state) > 0.0) {
                Vec3d pos = new Vec3d((double)this.pulley.getX(), posY, (double)this.pulley.getZ()).addVector((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
                this.getEntityWorld().getEntitiesWithinAABBExcludingEntity((Entity)this, EntityExtendingRope.createAABB(pos, pos.addVector(1.0, this.getBlockStateHeight((IBlockState)state), 1.0))).forEach(e -> {
                    if (!(e instanceof EntityExtendingRope)) {
                        double targetY = pos.y + this.getBlockStateHeight((IBlockState)state) - 0.01;
                        if ((!entMaxY.containsKey(e) || (Double)entMaxY.get(e) < targetY) && (!this.getEntityWorld().isRemote ^ e instanceof EntityPlayer || b)) {
                            entitiesInBlocks.add(e);
                            entMaxY.put(e, targetY);
                        }
                    }
                });
            }
        });
        this.getEntityWorld().getEntitiesWithinAABBExcludingEntity((Entity)this, AABBArray.toAABB(this.getEntityBoundingBox()).expand(0.0, 0.5, 0.0).offset(0.0, 0.5, 0.0)).forEach(e -> {
            if (!(e instanceof EntityExtendingRope || e instanceof EntityPlayer && ((EntityPlayer)e).capabilities.isFlying)) {
                passengers.add(e);
            }
        });
        passengers.forEach(e -> e.move(null, 0.0, newPosY - posY, 0.0));
        passengers.forEach(e -> {
            e.fallDistance = 0.0f;
        });
        entitiesInBlocks.forEach(e -> e.setPosition(e.posX, Math.max(e.posY, (Double)entMaxY.get(e) + newPosY - posY), e.posZ));
        entitiesInBlocks.forEach(e -> {
            e.isAirBorne = false;
        });
        entitiesInBlocks.forEach(e -> {
            e.onGround = true;
        });
        entitiesInBlocks.forEach(e -> {
            e.motionY = Math.max(this.up ? 0.0 : -0.1, e.motionY);
        });
    }

    private double getBlockStateHeight(IBlockState blockState) {
        return blockState == null ? 1.0f : (blockState.getBlock() == BWMBlocks.ANCHOR ? 0.375f : (float)(!(blockState.getBlock() instanceof BlockRailBase) && !(blockState.getBlock() instanceof BlockRedstoneWire) ? 1 : 0));
    }

    public boolean canRenderOnFire() {
        return false;
    }

    private boolean done() {
        TileEntityPulley pulley;
        TileEntity te;
        if (!this.getEntityWorld().isRemote && (te = this.getEntityWorld().getTileEntity(this.pulley)) instanceof TileEntityPulley && !(pulley = (TileEntityPulley)te).onJobCompleted(this.up, this.targetY, this)) {
            BlockPos pos = this.pulley.down(this.pulley.getY() - this.targetY);
            int retries = 0;
            while (!this.blocks.isEmpty() && retries < 10) {
                ++retries;
                int skipped = 0;
                for (Map.Entry<Vec3i, IBlockState> entry : this.blocks.entrySet()) {
                    BlockPos blockPos = pos.add(entry.getKey());
                    IBlockState state2 = entry.getValue();
                    if (state2.getBlock().canPlaceBlockAt(this.getEntityWorld(), blockPos)) {
                        TileEntity tile;
                        this.getEntityWorld().setBlockState(blockPos, state2, 3);
                        if (this.tiles.containsKey(entry.getKey()) && (tile = this.getEntityWorld().getTileEntity(blockPos)) != null) {
                            NBTTagCompound tag = this.tiles.get(entry.getKey());
                            tile.readFromNBT(tag);
                            tile.setPos(blockPos);
                        }
                        this.blocks.remove(entry.getKey());
                        this.tiles.remove(entry.getKey());
                        skipped = 0;
                        break;
                    }
                    ++skipped;
                }
                if (skipped != 0) continue;
                retries = 0;
            }
            if (retries > 0) {
                this.blocks.forEach((vec, state) -> state.getBlock().getDrops((IBlockAccess)this.getEntityWorld(), pos, state, 0).forEach(stack -> this.getEntityWorld().spawnEntity((Entity)new EntityItem(this.getEntityWorld(), this.posX, this.posY, this.posZ, stack))));
            }
            this.updatePassengers(this.posY, (double)this.targetY + 0.25, true);
            return true;
        }
        return false;
    }

    public void addBlock(Vec3i offset, World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos).getActualState((IBlockAccess)world, pos);
        TileEntity tile = world.getTileEntity(pos);
        this.blocks.put(offset, state);
        if (tile != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tile.writeToNBT(tag);
            this.tiles.put(offset, tag);
            world.removeTileEntity(pos);
        }
        this.rebuildBlockBoundingBox();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.pulley.getX());
        buffer.writeInt(this.pulley.getY());
        buffer.writeInt(this.pulley.getZ());
        buffer.writeInt(this.targetY);
        buffer.writeBoolean(this.up);
        this.serializeBlockmap(buffer, this.blocks);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.pulley = new BlockPos(additionalData.readInt(), additionalData.readInt(), additionalData.readInt());
        this.targetY = additionalData.readInt();
        this.up = additionalData.readBoolean();
        this.blocks = this.deserializeBlockmap(additionalData);
    }

    public int getTargetY() {
        return this.targetY;
    }

    public void setTargetY(int i) {
        this.targetY = i;
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public boolean getUp() {
        return this.up;
    }

    protected boolean canFitPassenger(Entity passenger) {
        return false;
    }

    public boolean isPathBlocked() {
        HashSet blocked = new HashSet();
        this.blocks.forEach((vec, state) -> {
            if (blocked.isEmpty() && !this.up || state.getBlock() != BWMBlocks.ANCHOR) {
                BlockPos pos = this.pulley.down(this.pulley.getY() - this.targetY).add(vec);
                pos = this.up ? pos.up() : pos.down();
                Block b = this.getEntityWorld().getBlockState(pos).getBlock();
                if (b != Blocks.AIR && !b.isReplaceable((IBlockAccess)this.getEntityWorld(), pos)) {
                    blocked.add(pos);
                }
            }
        });
        return !blocked.isEmpty();
    }

    public boolean writeToNBTOptional(NBTTagCompound compound) {
        return false;
    }

    public BlockPos getPulleyPosition() {
        return this.pulley;
    }

    public Map<Vec3i, IBlockState> getBlocks() {
        return this.blocks;
    }

    public Map<Vec3i, NBTTagCompound> getTiles() {
        return this.tiles;
    }

    protected void setSize(float width, float height) {
        if (this.blockBB == null) {
            super.setSize(width, height);
        }
    }

    public void setEntityBoundingBox(AxisAlignedBB bb) {
        this.rebuildBlockBoundingBox();
        super.setEntityBoundingBox((AxisAlignedBB)(this.blockBB != null ? this.blockBB.offset(this.posX, this.posY, this.posZ) : bb));
    }

    public AxisAlignedBB getBlockBoundingBox(Vec3i block, IBlockState state) {
        Vec3d pos = new Vec3d((double)this.pulley.getX(), this.posY, (double)this.pulley.getZ()).addVector((double)block.getX(), (double)block.getY(), (double)block.getZ());
        return new AxisAlignedBB(pos, pos.addVector(1.0, this.getBlockStateHeight(state), 1.0));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getCollisionBoundingBox() {
        return this.canBeCollidedWith() ? (this.getEntityBoundingBox() instanceof AABBArray ? ((AABBArray)this.getEntityBoundingBox()).forEach(i -> i.setMaxY(i.maxY - 0.125)) : this.getEntityBoundingBox()) : null;
    }
}

