/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.tile.TileFluid;
import betterwithmods.common.fluid.FluidTankRestricted;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityBucket
extends TileFluid
implements ITickable {
    private int ticks;

    @Override
    public FluidTank createTank() {
        return new FluidTankRestricted(new FluidStack(FluidRegistry.WATER, 0), this.getCapacity());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @Override
    public int getCapacity() {
        return 8000;
    }

    @Override
    public boolean hasFluid(EnumFacing facing) {
        return true;
    }

    private boolean isWater(IBlockState state) {
        return state.getBlock() == Blocks.WATER || state.getBlock() == Blocks.FLOWING_WATER;
    }

    public void update() {
        if (!this.isFull() && this.ticks > 100) {
            EnumFacing face;
            EnumFacing[] enumFacingArray = EnumFacing.HORIZONTALS;
            int n = enumFacingArray.length;
            for (int i = 0; !(i >= n || this.isWater(this.world.getBlockState(this.pos.offset(face = enumFacingArray[i]))) && this.fill(new FluidStack(FluidRegistry.WATER, 1000), true)); ++i) {
            }
            this.ticks = 0;
        }
        ++this.ticks;
    }
}

