/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mini;

import betterwithmods.common.blocks.mini.BlockMini;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockMoulding
extends BlockMini {
    private final AxisAlignedBB[] bounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 0.5), new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 0.5, 1.0), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0), new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0), new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5), new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.5), new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 1.0, 1.0), new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 1.0, 1.0)};

    public BlockMoulding(Material mat) {
        super(mat);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)TYPE, (Comparable)Integer.valueOf(0)).withProperty((IProperty)this.getOrientationProperty(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public BlockMini.PropertyOrientation getOrientationProperty() {
        return MOULDING_ORIENTATION;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        int ori = (Integer)this.getActualState(state, source, pos).getValue((IProperty)this.getOrientationProperty());
        if (ori > 11 || ori < 1) {
            return this.bounds[0];
        }
        return this.bounds[ori];
    }

    @Override
    public IBlockState getStateForAdvancedRotationPlacement(IBlockState defaultState, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockMini.PropertyOrientation facingProperty = this.getOrientationProperty();
        IBlockState state = defaultState;
        float hitXFromCenter = hitX - 0.5f;
        float hitYFromCenter = hitY - 0.5f;
        float hitZFromCenter = hitZ - 0.5f;
        switch (facing.getAxis()) {
            case Y: {
                int corner = this.getCorner(hitXFromCenter, hitZFromCenter);
                if (corner != -1) {
                    int[] corners = new int[]{11, 9, 8, 10};
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(corners[corner]));
                    break;
                }
                if (hitYFromCenter > 0.0f) {
                    if (this.isMax(hitXFromCenter, hitZFromCenter)) {
                        state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitXFromCenter > 0.0f ? 3 : 0));
                        break;
                    }
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitZFromCenter > 0.0f ? 2 : 1));
                    break;
                }
                if (this.isMax(hitXFromCenter, hitZFromCenter)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitXFromCenter > 0.0f ? 7 : 4));
                    break;
                }
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitZFromCenter > 0.0f ? 6 : 5));
                break;
            }
            case X: {
                int corner = this.getCorner(hitYFromCenter, hitZFromCenter);
                if (corner != -1) {
                    int[] corners = new int[]{6, 5, 1, 2};
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(corners[corner]));
                    break;
                }
                if (hitXFromCenter > 0.0f) {
                    if (this.isMax(hitYFromCenter, hitZFromCenter)) {
                        state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitYFromCenter > 0.0f ? 4 : 0));
                        break;
                    }
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitZFromCenter > 0.0f ? 10 : 8));
                    break;
                }
                if (this.isMax(hitYFromCenter, hitZFromCenter)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitYFromCenter > 0.0f ? 7 : 3));
                    break;
                }
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitZFromCenter > 0.0f ? 11 : 9));
                break;
            }
            case Z: {
                int corner = this.getCorner(hitYFromCenter, hitXFromCenter);
                if (corner != -1) {
                    int[] corners = new int[]{7, 4, 0, 3};
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(corners[corner]));
                    break;
                }
                if (hitZFromCenter > 0.0f) {
                    if (this.isMax(hitXFromCenter, hitYFromCenter)) {
                        state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitXFromCenter > 0.0f ? 9 : 8));
                        break;
                    }
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitYFromCenter > 0.0f ? 5 : 1));
                    break;
                }
                if (this.isMax(hitXFromCenter, hitYFromCenter)) {
                    state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitXFromCenter > 0.0f ? 11 : 10));
                    break;
                }
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(hitYFromCenter > 0.0f ? 6 : 2));
                break;
            }
            default: {
                state = state.withProperty((IProperty)facingProperty, (Comparable)Integer.valueOf(facing.getOpposite().getIndex()));
            }
        }
        return state;
    }

    private int getCorner(float hitXFromCenter, float hitZFromCenter) {
        boolean positiveX = hitXFromCenter > 0.0f;
        boolean positiveZ = hitZFromCenter > 0.0f;
        double x = Math.abs(hitXFromCenter);
        double z = Math.abs(hitZFromCenter);
        if (x > 0.25 && z > 0.25) {
            if (positiveX && positiveZ) {
                return 0;
            }
            if (positiveX && !positiveZ) {
                return 1;
            }
            if (!positiveX && !positiveZ) {
                return 2;
            }
            if (!positiveX && positiveZ) {
                return 3;
            }
        }
        return -1;
    }
}

