/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.blocks.mechanical.tile.TileAxleMachine;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.util.DirUtils;
import betterwithmods.util.WorldUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileSteelSaw
extends TileAxleMachine {
    public static final AxisAlignedBB X_BOX = new AxisAlignedBB(0.0, -1.0, -1.0, 0.0, 1.0, 1.0);
    public static final AxisAlignedBB Y_BOX = new AxisAlignedBB(-1.0, 0.0, -1.0, 1.0, 0.0, 1.0);
    public static final AxisAlignedBB Z_BOX = new AxisAlignedBB(-1.0, -1.0, 0.0, 1.0, 1.0, 0.0);
    public static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{X_BOX, Y_BOX, Z_BOX};

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox();
    }

    @Override
    public int getPower() {
        if (!this.isValid()) {
            return 0;
        }
        return super.getPower();
    }

    public boolean isValid() {
        IBlockState state = this.world.getBlockState(this.pos);
        boolean valid = true;
        Set<BlockPos> positions = WorldUtils.getPosAround(this.pos, (EnumFacing.Axis)state.getValue(DirUtils.AXIS));
        for (BlockPos check : positions) {
            if (check.equals((Object)this.getPos()) || this.saw(this.world, check, this.world.rand, true)) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public void update() {
        IBlockState state = this.world.getBlockState(this.pos);
        Set<BlockPos> positions = WorldUtils.getPosAround(this.pos, (EnumFacing.Axis)state.getValue(DirUtils.AXIS));
        if (this.getPower() > 0 && this.world.getTotalWorldTime() % 10L == 0L) {
            List items;
            EnumFacing.Axis axis = (EnumFacing.Axis)state.getValue(DirUtils.AXIS);
            AxisAlignedBB box = BOXES[axis.ordinal()].offset(this.pos);
            List entities = this.world.getEntitiesWithinAABB(EntityLivingBase.class, box.grow(0.25));
            if (!entities.isEmpty()) {
                entities.forEach(this::hitEntity);
                this.world.playSound(null, this.pos, SoundEvents.ENTITY_MINECART_RIDING, SoundCategory.BLOCKS, 1.0f + this.world.rand.nextFloat() * 0.1f, 1.5f + this.world.rand.nextFloat() * 0.1f);
            }
            if (!(items = this.world.getEntitiesWithinAABB(EntityItem.class, box.grow(0.5))).isEmpty()) {
                items.forEach(item -> this.moveItems(axis, (EntityItem)item));
                this.world.playSound(null, this.pos, SoundEvents.ENTITY_MINECART_RIDING, SoundCategory.BLOCKS, 1.0f + this.world.rand.nextFloat() * 0.1f, 1.5f + this.world.rand.nextFloat() * 0.1f);
            }
            for (BlockPos pos : positions) {
                if (pos.equals((Object)this.getPos())) continue;
                this.saw(this.world, pos, this.world.rand, false);
            }
        }
    }

    private void moveItems(EnumFacing.Axis axis, EntityItem item) {
        BlockPos itemPos = item.getPosition();
        int x = this.getPos().getX() - itemPos.getX();
        int y = this.getPos().getY() - itemPos.getY();
        int z = this.getPos().getZ() - itemPos.getZ();
        switch (axis) {
            default: {
                break;
            }
            case X: {
                if (z != 0) break;
                item.setVelocity(0.0, 0.0, (double)y / 2.0);
                break;
            }
            case Z: {
                if (x != 0) break;
                item.setVelocity((double)y / 2.0, 0.0, 0.0);
            }
        }
    }

    private void hitEntity(EntityLivingBase entity) {
        entity.recentlyHit = 60;
        if (this.world instanceof WorldServer && BWDamageSource.getSawDamage() != null) {
            entity.attackEntityFrom((DamageSource)BWDamageSource.getSteelSawDamage(), 10.0f);
        }
    }

    @Override
    public byte getMaximumSignal() {
        return 5;
    }

    private boolean saw(World world, BlockPos pos, Random rand, boolean simulate) {
        return false;
    }

    @Override
    public World getBlockWorld() {
        return super.getBlockWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getBlockPos();
    }
}

