/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.common.blocks.mechanical.tile.TileGearbox;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileMerger
extends TileGearbox {
    private List<Integer> leftHistory = Lists.newArrayList((Object[])new Integer[]{0, 0, 0, 0, 0});
    private List<Integer> rightHistory = Lists.newArrayList((Object[])new Integer[]{0, 0, 0, 0, 0});

    public TileMerger(int maxPower) {
        super(maxPower);
    }

    @Override
    public void onChanged() {
        if (this.getBlockWorld().getTotalWorldTime() % 20L != 0L) {
            return;
        }
        if (BWMAPI.IMPLEMENTATION.isRedstonePowered(this.world, this.pos)) {
            this.setPower(0);
            this.markDirty();
            return;
        }
        int left = this.getMechanicalInput(this.getFacing());
        int right = this.getMechanicalInput(this.getFacing().getOpposite());
        if (left < 1 || right < 1) {
            return;
        }
        if (left != right) {
            this.getBlock().overpower(this.world, this.pos);
        } else {
            int power = 3 * left;
            if (power != this.power) {
                this.setPower(power);
            }
            this.markDirty();
        }
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing != this.getFacing() && facing != this.getFacing().getOpposite() && BWMAPI.IMPLEMENTATION.isAxle((IBlockAccess)this.world, this.pos.offset(facing), facing.getOpposite())) {
            return Math.min(this.power, this.maxPower);
        }
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        BlockPos pos = this.getBlockPos().offset(facing);
        if (BWMAPI.IMPLEMENTATION.getMechanicalPower(this.world, pos, facing.getOpposite()) != null && !(BWMAPI.IMPLEMENTATION.getMechanicalPower(this.world, pos, facing.getOpposite()) instanceof TileGearbox)) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, pos, facing.getOpposite());
        }
        return 0;
    }
}

