/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.blocks.mechanical.BlockGearbox;
import betterwithmods.common.blocks.tile.TileBasic;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileGearbox
extends TileBasic
implements IMechanicalPower {
    protected int power;
    protected int maxPower;
    protected int tick;
    protected int unchanged;

    public TileGearbox() {
    }

    public TileGearbox(int maxPower) {
        this.maxPower = maxPower;
    }

    public void onChanged() {
        ++this.tick;
        if (this.tick < 20) {
            return;
        }
        this.tick = 0;
        if (BWMAPI.IMPLEMENTATION.isRedstonePowered(this.world, this.pos)) {
            this.setPower(0);
            this.markDirty();
            return;
        }
        int power = this.getMechanicalInput(this.getFacing());
        if (power != this.power) {
            this.setPower(power);
            this.unchanged = 0;
        } else {
            ++this.unchanged;
        }
        if (this.isOverpowered() && this.unchanged > 30) {
            this.getBlock().overpower(this.world, this.pos);
        }
        this.markDirty();
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 1;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (facing != this.getFacing() && BWMAPI.IMPLEMENTATION.isAxle((IBlockAccess)this.world, this.pos.offset(facing), facing.getOpposite())) {
            return Math.min(this.power, this.maxPower);
        }
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        BlockPos pos = this.getBlockPos().offset(facing);
        if (BWMAPI.IMPLEMENTATION.getMechanicalPower(this.world, pos, facing.getOpposite()) != null && !(BWMAPI.IMPLEMENTATION.getMechanicalPower(this.world, pos, facing.getOpposite()) instanceof TileGearbox)) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, pos, facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return this.maxPower;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.getInteger("power");
        this.maxPower = tag.getInteger("maxPower");
    }

    @Nonnull
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        tag.setInteger("power", this.power);
        tag.setInteger("maxPower", this.maxPower);
        return t;
    }

    @Override
    public BlockGearbox getBlock() {
        return (BlockGearbox)this.getBlockType();
    }

    public EnumFacing getFacing() {
        return this.getBlock().getFacing((IBlockAccess)this.world, this.pos);
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public void markDirty() {
        super.markDirty();
        this.getBlock().setActive(this.world, this.pos, this.power > 0);
    }

    public String toString() {
        return String.format("%s", this.power);
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    public boolean isOverpowered() {
        return this.power > this.getMaximumInput(this.getFacing());
    }
}

