/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockWindmill;
import betterwithmods.common.blocks.mechanical.tile.TileEntityBaseWindmill;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillHorizontal
extends TileEntityBaseWindmill {
    public TileEntityWindmillHorizontal() {
        this.bladeMeta = new int[]{0, 0, 0, 0};
    }

    @Override
    public void verifyIntegrity() {
        boolean valid = true;
        if (this.getBlockWorld().getBlockState(this.pos).getBlock() == BWMBlocks.WINDMILL) {
            EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().getBlockState(this.pos).getValue(DirUtils.AXIS);
            for (int vert = -6; vert <= 6; ++vert) {
                for (int i = -6; i <= 6; ++i) {
                    int xP = axis == EnumFacing.Axis.Z ? i : 0;
                    int zP = axis == EnumFacing.Axis.X ? i : 0;
                    BlockPos offset = this.pos.add(xP, vert, zP);
                    if ((xP != 0 || vert != 0 || zP != 0) && !(valid = this.getBlockWorld().isAirBlock(offset))) break;
                }
                if (!valid) break;
            }
        }
        this.isValid = valid && this.getBlockWorld().canBlockSeeSky(this.pos) && !this.isNether() && !this.isEnd();
    }

    @Override
    public int getRadius() {
        return 7;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.getBlockWorld().getBlockState(this.pos);
        if (!(state.getBlock() instanceof BlockWindmill)) {
            return Block.FULL_BLOCK_AABB;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().getBlockState(this.pos).getValue(DirUtils.AXIS);
        EnumFacing facing = axis == EnumFacing.Axis.Z ? EnumFacing.SOUTH : EnumFacing.EAST;
        Vec3i vec = facing.getDirectionVec();
        int xP = axis == EnumFacing.Axis.Z ? this.getRadius() : 0;
        int yP = this.getRadius();
        int zP = axis == EnumFacing.Axis.X ? this.getRadius() : 0;
        return new AxisAlignedBB((double)(-xP), (double)(-yP), (double)(-zP), (double)xP, (double)yP, (double)zP).offset(0.5, 0.5, 0.0).offset(this.pos).expand((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
    }
}

