/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.block.IWaterCurrent;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.mechanical.BlockWaterwheel;
import betterwithmods.common.blocks.mechanical.tile.TileAxleGenerator;
import betterwithmods.util.DirUtils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWaterwheel
extends TileAxleGenerator {
    static HashMap<Block, IWaterCurrent> WATER_BLOCKS = new HashMap();

    public static void registerWater(Block block) {
        if (block instanceof BlockLiquid) {
            TileEntityWaterwheel.registerWater(block, IWaterCurrent.VANILLA_LIQUID);
        } else if (block instanceof BlockFluidBase) {
            TileEntityWaterwheel.registerWater(block, IWaterCurrent.FORGE_LIQUID);
        } else {
            TileEntityWaterwheel.registerWater(block, IWaterCurrent.NO_FLOW);
        }
    }

    public static void registerWater(Block block, IWaterCurrent handler) {
        WATER_BLOCKS.put(block, handler);
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public boolean isWater(BlockPos pos) {
        IBlockState state = this.world.getBlockState(pos);
        return this.isVanillaWater(state) || this.isForgeFluid(state.getBlock()) || WATER_BLOCKS.containsKey(state.getBlock());
    }

    public IWaterCurrent getCurrentHandler(IBlockState state) {
        if (this.isVanillaWater(state)) {
            return IWaterCurrent.VANILLA_LIQUID;
        }
        if (this.isForgeFluid(state.getBlock())) {
            return IWaterCurrent.FORGE_LIQUID;
        }
        return WATER_BLOCKS.get(state.getBlock());
    }

    private boolean isVanillaWater(IBlockState state) {
        return state.getBlock() instanceof BlockLiquid && state.getMaterial() == Material.WATER;
    }

    private boolean isForgeFluid(Block block) {
        return block instanceof BlockFluidBase && ((BlockFluidBase)block).getFluid() == FluidRegistry.WATER;
    }

    @Override
    public void verifyIntegrity() {
        boolean isAir = true;
        boolean hasWater = true;
        if (this.getBlockWorld().getBlockState(this.pos).getBlock() == BWMBlocks.WATERWHEEL) {
            EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().getBlockState(this.pos).getValue(DirUtils.AXIS);
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    int xPos = axis == EnumFacing.Axis.Z ? i : 0;
                    int zPos = axis == EnumFacing.Axis.X ? i : 0;
                    BlockPos offset = this.pos.add(xPos, j, zPos);
                    if (j == -2) {
                        hasWater = this.isWater(offset);
                    }
                    if (!hasWater && !(hasWater = this.sidesHaveWater())) break;
                    if (i == 0 && j == 0) continue;
                    if (j > -2) {
                        isAir = i == -2 || i == 2 ? this.getBlockWorld().isAirBlock(offset) || this.isWater(offset) : this.getBlockWorld().isAirBlock(offset);
                    }
                    if (!isAir) break;
                }
                if (!isAir || !hasWater) break;
            }
        }
        this.isValid = isAir && hasWater;
    }

    public boolean sidesHaveWater() {
        EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().getBlockState(this.pos).getValue(DirUtils.AXIS);
        int leftWater = 0;
        int rightWater = 0;
        boolean bottomIsUnobstructed = true;
        for (int i = -2; i <= 2; ++i) {
            int xLeft = axis == EnumFacing.Axis.Z ? -2 : 0;
            int xRight = axis == EnumFacing.Axis.Z ? 2 : 0;
            int zLeft = axis == EnumFacing.Axis.X ? -2 : 0;
            int zRight = axis == EnumFacing.Axis.X ? 2 : 0;
            BlockPos leftPos = this.pos.add(xLeft, i, zLeft);
            BlockPos rightPos = this.pos.add(xRight, i, zRight);
            if (this.isWater(leftPos)) {
                ++leftWater;
            } else if (this.isWater(rightPos)) {
                ++rightWater;
            }
            int xP = axis == EnumFacing.Axis.Z ? i : 0;
            int yP = -2;
            int zP = axis == EnumFacing.Axis.X ? i : 0;
            BlockPos bPos = this.pos.add(xP, yP, zP);
            boolean bl = bottomIsUnobstructed = this.getBlockWorld().isAirBlock(bPos) || this.isWater(bPos);
            if (!bottomIsUnobstructed) break;
        }
        return !(!bottomIsUnobstructed || leftWater == 0 && rightWater == 0 || leftWater >= rightWater && leftWater <= rightWater);
    }

    @Override
    public void calculatePower() {
        byte power = 0;
        if (this.isValid()) {
            int i;
            Vec3d overallFlow = Vec3d.ZERO;
            EnumFacing.Axis axis = (EnumFacing.Axis)this.getBlockWorld().getBlockState(this.pos).getValue(DirUtils.AXIS);
            int leftWater = 0;
            int rightWater = 0;
            for (i = 0; i < 3; ++i) {
                int metaPos = i - 1;
                int xP = axis == EnumFacing.Axis.Z ? metaPos : 0;
                int zP = axis == EnumFacing.Axis.X ? metaPos : 0;
                BlockPos lowPos = this.pos.add(xP, -2, zP);
                IBlockState lowState = this.getBlockWorld().getBlockState(lowPos);
                IWaterCurrent current = this.getCurrentHandler(lowState);
                if (current == null) continue;
                overallFlow = overallFlow.add(current.getFlowDirection(this.getBlockWorld(), lowPos, lowState));
            }
            for (i = -1; i < 3; ++i) {
                int xLeft = axis == EnumFacing.Axis.Z ? -2 : 0;
                int xRight = axis == EnumFacing.Axis.Z ? 2 : 0;
                int zLeft = axis == EnumFacing.Axis.X ? -2 : 0;
                int zRight = axis == EnumFacing.Axis.X ? 2 : 0;
                BlockPos leftPos = this.pos.add(xLeft, i, zLeft);
                BlockPos rightPos = this.pos.add(xRight, i, zRight);
                if (this.isWater(leftPos)) {
                    ++leftWater;
                }
                if (!this.isWater(rightPos)) continue;
                ++rightWater;
            }
            int xFlow = Math.abs(overallFlow.x) > 2.0 ? (int)Math.signum(overallFlow.x) : 0;
            int zFlow = Math.abs(overallFlow.z) > 2.0 ? (int)Math.signum(overallFlow.z) : 0;
            int relevantFlow = 0;
            if (axis == EnumFacing.Axis.X) {
                relevantFlow = zFlow;
            }
            if (axis == EnumFacing.Axis.Z) {
                relevantFlow = xFlow;
            }
            this.waterMod = leftWater > rightWater || relevantFlow > 0 && leftWater >= rightWater ? -1.0f : (rightWater > leftWater || relevantFlow < 0 && rightWater >= leftWater ? 1.0f : 0.0f);
            if (this.waterMod != 0.0f) {
                power = 1;
            }
        }
        if (power != this.power) {
            this.setPower(power);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        IBlockState state = this.getBlockWorld().getBlockState(this.pos);
        if (!(state.getBlock() instanceof BlockWaterwheel)) {
            return Block.FULL_BLOCK_AABB;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.getValue(DirUtils.AXIS);
        EnumFacing facing = axis == EnumFacing.Axis.Z ? EnumFacing.SOUTH : EnumFacing.EAST;
        Vec3i vec = facing.getDirectionVec();
        int xP = axis == EnumFacing.Axis.Z ? this.getRadius() : 0;
        int yP = this.getRadius();
        int zP = axis == EnumFacing.Axis.X ? this.getRadius() : 0;
        return new AxisAlignedBB((double)(-xP), (double)(-yP), (double)(-zP), (double)xP, (double)yP, (double)zP).offset(0.5, 0.5, 0.5).offset(this.pos).expand((double)vec.getX(), (double)vec.getY(), (double)vec.getZ());
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }

    @Override
    public int getRadius() {
        return 2;
    }
}

