/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.tile.IMechSubtype;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.common.registry.TurntableRotationManager;
import betterwithmods.common.registry.block.recipe.TurntableRecipe;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityTurntable
extends TileBasic
implements IMechSubtype,
ITickable,
IMechanicalPower {
    private static final int height = 3;
    private static final int[] ticksToRotate = new int[]{10, 20, 40, 80};
    public byte timerPos = 0;
    private int potteryRotation = 0;
    private double[] offsets = new double[]{0.25, 0.375, 0.5, 0.625};
    private boolean asynchronous = false;
    private int rotationTime = 0;
    private int power;

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("SwitchSetting")) {
            this.timerPos = tag.getByte("SwitchSetting");
            if (this.timerPos > 3) {
                this.timerPos = (byte)3;
            }
        }
        if (tag.hasKey("PotteryRotation")) {
            this.potteryRotation = tag.getInteger("PotteryRotation");
        }
        if (tag.hasKey("Asynchronous")) {
            this.asynchronous = tag.getBoolean("Asynchronous");
        }
        if (tag.hasKey("RotationTime")) {
            this.rotationTime = tag.getInteger("RotationTime");
        }
        this.power = tag.getInteger("power");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("PotteryRotation", this.potteryRotation);
        tag.setByte("SwitchSetting", this.timerPos);
        tag.setBoolean("Asynchronous", this.asynchronous);
        if (this.asynchronous || this.rotationTime != 0) {
            tag.setInteger("RotationTime", this.rotationTime);
        }
        tag.setInteger("power", this.power);
        return tag;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    public void update() {
        if (!this.getBlockWorld().isRemote) {
            this.power = this.calculateInput();
            if (this.power > 0) {
                if (!this.asynchronous && this.getBlockWorld().getTotalWorldTime() % (long)ticksToRotate[this.timerPos] == 0L) {
                    this.getBlockWorld().playSound(null, this.pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.05f, 1.0f);
                    this.rotateTurntable();
                } else if (this.asynchronous) {
                    ++this.rotationTime;
                    if (this.rotationTime >= ticksToRotate[this.timerPos]) {
                        this.rotationTime = 0;
                        this.getBlockWorld().playSound(null, this.pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.05f, 1.0f);
                        this.rotateTurntable();
                    }
                }
            }
        }
    }

    public boolean processRightClick(EntityPlayer player) {
        if (!player.getHeldItem(EnumHand.MAIN_HAND).isEmpty()) {
            if (player.getHeldItem(EnumHand.MAIN_HAND).getItem() == Items.CLOCK) {
                this.toggleAsynchronous(player);
                return true;
            }
        } else if (player.getHeldItemMainhand().isEmpty()) {
            this.advanceTimerPos();
            this.getBlockWorld().scheduleBlockUpdate(this.pos, this.getBlockType(), this.getBlockType().tickRate(this.getBlockWorld()), 5);
            this.getBlockWorld().playSound(null, this.pos, SoundEvents.BLOCK_WOOD_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
            return true;
        }
        return false;
    }

    public void toggleAsynchronous(EntityPlayer player) {
        if (!this.getBlockWorld().getGameRules().getBoolean("doDaylightCycle")) {
            if (!this.asynchronous) {
                this.asynchronous = true;
            } else if (player != null) {
                player.sendStatusMessage((ITextComponent)new TextComponentTranslation("message.bwm:async.unavailable", new Object[0]), false);
            }
        } else {
            boolean async;
            boolean isSneaking = player.isSneaking();
            String isOn = "enabled";
            boolean bl = async = !this.asynchronous;
            if (!async && !isSneaking || async && isSneaking) {
                isOn = "disabled";
            }
            player.sendStatusMessage((ITextComponent)new TextComponentTranslation("message.bwm:async." + isOn, new Object[0]), false);
            if (!isSneaking) {
                this.getBlockWorld().playSound(null, this.pos, SoundEvents.BLOCK_STONE_BUTTON_CLICK_ON, SoundCategory.BLOCKS, 0.05f, 1.0f);
                this.asynchronous = async;
            }
        }
    }

    public void rotateTurntable() {
        Rotation rotation = BWMAPI.IMPLEMENTATION.isRedstonePowered(this.world, this.pos) ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(this.getPos());
        for (int i = 1; i < 3; ++i) {
            pos.setY(pos.getY() + 1);
            TurntableRotationManager.IRotation handler = this.rotateBlock((BlockPos)pos, rotation);
            if (handler == null) break;
            if (handler.canTransmitHorizontally(this.world, (BlockPos)pos)) {
                TurntableRotationManager.rotateAttachments(this.world, (BlockPos)pos, rotation);
            }
            if (!handler.canTransmitVertically(this.world, (BlockPos)pos)) break;
        }
        this.getBlockWorld().neighborChanged((BlockPos)pos, BWMBlocks.SINGLE_MACHINES, (BlockPos)pos);
    }

    public byte getTimerPos() {
        return this.timerPos;
    }

    public double getOffset() {
        return this.offsets[this.timerPos];
    }

    public void advanceTimerPos() {
        this.timerPos = (byte)(this.timerPos + 1);
        if (this.timerPos > 3) {
            this.timerPos = 0;
        }
        IBlockState state = this.getBlockWorld().getBlockState(this.pos);
        this.getBlockWorld().notifyBlockUpdate(this.pos, state, state, 3);
    }

    private TurntableRotationManager.IRotation rotateBlock(BlockPos pos, Rotation rotation) {
        IBlockState input = this.getBlockWorld().getBlockState(pos);
        this.rotateCraftable(this.world, pos, input);
        return TurntableRotationManager.rotate(this.world, pos, rotation);
    }

    private void spawnParticlesAndSound(IBlockState state) {
        if (state.getMaterial() != Material.AIR) {
            this.world.playSound(null, this.pos, state.getBlock().getSoundType(state, this.world, this.pos, null).getPlaceSound(), SoundCategory.BLOCKS, 0.5f, this.world.rand.nextFloat() * 0.1f + 0.8f);
            ((WorldServer)this.world).spawnParticle(EnumParticleTypes.BLOCK_DUST, (double)this.pos.getX() + 0.5, (double)(this.pos.getY() + 1), (double)this.pos.getZ() + 0.5, 30, 0.0, 0.5, 0.0, (double)0.15f, new int[]{Block.getStateId((IBlockState)state)});
        }
    }

    private void rotateCraftable(World world, BlockPos pos, IBlockState input) {
        TurntableRecipe recipe = BWRegistry.TURNTABLE.findRecipe(world, pos, input).orElse(null);
        if (recipe != null) {
            ++this.potteryRotation;
            this.spawnParticlesAndSound(input);
            if (recipe.craftRecipe(world, pos, world.rand, input)) {
                this.potteryRotation = 0;
            }
        } else {
            this.potteryRotation = 0;
        }
    }

    @Override
    public int getSubtype() {
        return this.timerPos + 8;
    }

    @Override
    public void setSubtype(int type) {
        this.timerPos = (byte)Math.min(type, 3);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }

    public int getPotteryRotation() {
        return this.potteryRotation;
    }
}

