/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.BWMod;
import betterwithmods.api.BWMAPI;
import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.api.tile.IRopeConnector;
import betterwithmods.api.util.IProgressSource;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.mechanical.BlockMechMachines;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.registry.PulleyStructureManager;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.InvUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPulley
extends TileEntityVisibleInventory
implements IMechanicalPower,
IProgressSource {
    private EntityExtendingRope rope;
    private NBTTagCompound ropeTag = null;
    private int power;

    public boolean isPowered() {
        return this.power > 0;
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    public boolean isRaising() {
        return !BWMAPI.IMPLEMENTATION.isRedstonePowered(this.world, this.pos) && this.isPowered();
    }

    public boolean isLowering() {
        return !BWMAPI.IMPLEMENTATION.isRedstonePowered(this.world, this.pos) && !this.isPowered();
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return super.createItemStackHandler();
    }

    @Override
    public String getName() {
        return "inv.pulley.name";
    }

    @Override
    public int getMaxVisibleSlots() {
        return 4;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int z;
        int y;
        int x = this.pos.getX();
        return player.getDistanceSq((double)x + 0.5, (double)(y = this.pos.getY()) + 0.5, (double)(z = this.pos.getZ()) + 0.5) <= 64.0;
    }

    public void update() {
        if (this.getBlockWorld().isRemote) {
            return;
        }
        this.tryNextOperation();
    }

    private void tryNextOperation() {
        this.power = this.calculateInput();
        if (!this.activeOperation() && this.getBlockWorld().getBlockState(this.pos).getBlock() instanceof BlockMechMachines) {
            if (this.canGoDown(false)) {
                this.goDown();
            } else if (this.canGoUp()) {
                this.goUp();
            }
        }
    }

    private boolean validRopeConnector(BlockPos pos) {
        IBlockState state = this.getBlockWorld().getBlockState(pos);
        return state.getBlock() instanceof IRopeConnector && ((IRopeConnector)state.getBlock()).getFacing(state) == EnumFacing.UP;
    }

    private boolean canGoUp() {
        BlockPos lowest;
        return this.isRaising() && this.putRope(false) && !(lowest = BlockRope.getLowestRopeBlock(this.getBlockWorld(), this.pos)).equals((Object)this.pos);
    }

    private boolean canGoDown(boolean isMoving) {
        if (this.isLowering() && this.takeRope(false)) {
            boolean flag;
            BlockPos newPos = BlockRope.getLowestRopeBlock(this.getBlockWorld(), this.pos).down();
            IBlockState state = this.getBlockWorld().getBlockState(newPos);
            boolean bl = flag = !isMoving && this.validRopeConnector(newPos);
            if (newPos.getY() > 0 && (this.getBlockWorld().isAirBlock(newPos) || state.getBlock().isReplaceable((IBlockAccess)this.getBlockWorld(), newPos) || flag) && newPos.up().getY() > 0) {
                return true;
            }
        }
        return false;
    }

    private void goUp() {
        BlockPos lowest = BlockRope.getLowestRopeBlock(this.getBlockWorld(), this.pos);
        boolean flag = this.validRopeConnector(lowest.down());
        this.rope = new EntityExtendingRope(this.getBlockWorld(), this.pos, lowest, lowest.up().getY());
        if (!flag || this.movePlatform(lowest.down(), true)) {
            this.getBlockWorld().playSound(null, this.pos.down(), SoundEvents.BLOCK_GRASS_BREAK, SoundCategory.BLOCKS, 0.4f + this.getBlockWorld().rand.nextFloat() * 0.1f, 1.0f);
            this.getBlockWorld().spawnEntity((Entity)this.rope);
            this.getBlockWorld().setBlockToAir(lowest);
            this.putRope(true);
        } else {
            this.rope = null;
        }
    }

    private void goDown() {
        BlockPos newPos = BlockRope.getLowestRopeBlock(this.getBlockWorld(), this.pos).down();
        boolean flag = this.validRopeConnector(newPos);
        this.rope = new EntityExtendingRope(this.getBlockWorld(), this.pos, newPos.up(), newPos.getY());
        if (!flag || this.movePlatform(newPos, false)) {
            this.getBlockWorld().spawnEntity((Entity)this.rope);
        } else {
            this.rope = null;
        }
    }

    private boolean movePlatform(BlockPos anchor, boolean up) {
        boolean success;
        IBlockState state = this.getBlockWorld().getBlockState(anchor);
        if (!(state.getBlock() instanceof IRopeConnector)) {
            return false;
        }
        HashSet<BlockPos> platformBlocks = new HashSet<BlockPos>();
        platformBlocks.add(anchor);
        BlockPos below = anchor.down();
        if (this.isPlatform(below) && ((IRopeConnector)state.getBlock()).canMovePlatforms(this.world, anchor)) {
            success = this.addToList(platformBlocks, below, up);
        } else {
            boolean bl = success = up || this.isIgnoreable(below);
        }
        if (!success) {
            return false;
        }
        for (BlockPos blockPos : platformBlocks) {
            Arrays.asList(blockPos.north(), blockPos.south()).forEach(p -> {
                if (!platformBlocks.contains(p)) {
                    this.fixRail((BlockPos)p, BlockRailBase.EnumRailDirection.ASCENDING_NORTH, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                }
            });
            Arrays.asList(blockPos.east(), blockPos.west()).forEach(p -> {
                if (!platformBlocks.contains(p)) {
                    this.fixRail((BlockPos)p, BlockRailBase.EnumRailDirection.ASCENDING_EAST, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                }
            });
        }
        if (!this.getBlockWorld().isRemote) {
            for (BlockPos blockPos : platformBlocks) {
                BlockPos offset = blockPos.subtract((Vec3i)anchor.up());
                this.rope.addBlock((Vec3i)offset, this.getBlockWorld(), blockPos);
                if (this.isMoveableBlock(blockPos.up())) {
                    this.rope.addBlock(new Vec3i(offset.getX(), offset.getY() + 1, offset.getZ()), this.getBlockWorld(), blockPos.up());
                    this.getBlockWorld().setBlockToAir(blockPos.up());
                }
                this.getBlockWorld().setBlockToAir(blockPos);
            }
        }
        return true;
    }

    public boolean isIgnoreable(BlockPos pos) {
        return this.world.isAirBlock(pos) || this.world.getBlockState(pos).getMaterial().isReplaceable();
    }

    public boolean isMoveableBlock(BlockPos pos) {
        IBlockState state = this.world.getBlockState(pos);
        return state.getBlock() == Blocks.REDSTONE_WIRE || state.getBlock() instanceof BlockRailBase;
    }

    public boolean isPlatform(BlockPos pos) {
        IBlockState state = this.world.getBlockState(pos);
        return PulleyStructureManager.isPulleyBlock(state);
    }

    private void fixRail(BlockPos rail, BlockRailBase.EnumRailDirection ... directions) {
        List<BlockRailBase.EnumRailDirection> list = Arrays.asList(directions);
        IBlockState state = this.getBlockWorld().getBlockState(rail);
        if (this.getBlockWorld().getBlockState(rail).getBlock() instanceof BlockRailBase) {
            PropertyEnum shape = null;
            for (IProperty p : state.getPropertyKeys()) {
                if (!"shape".equals(p.getName()) || !(p instanceof PropertyEnum)) continue;
                shape = (PropertyEnum)p;
                break;
            }
            if (shape != null) {
                BlockRailBase.EnumRailDirection currentShape = (BlockRailBase.EnumRailDirection)state.getValue(shape);
                if (list.contains(currentShape)) {
                    this.getBlockWorld().setBlockState(rail, state.withProperty((IProperty)shape, (Comparable)this.flatten(currentShape)), 6);
                }
            } else {
                BWMod.logger.warn(String.format("Rail at %s has no shape?", rail));
            }
        }
    }

    private BlockRailBase.EnumRailDirection flatten(BlockRailBase.EnumRailDirection old) {
        switch (old) {
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return BlockRailBase.EnumRailDirection.EAST_WEST;
            }
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            }
        }
        return old;
    }

    private boolean addToList(HashSet<BlockPos> set, BlockPos p, boolean up) {
        BlockPos blockCheck;
        if (set.size() > GlobalConfig.maxPlatformBlocks) {
            return false;
        }
        if (!this.isPlatform(p)) {
            return true;
        }
        BlockPos blockPos = blockCheck = up ? p.up() : p.down();
        if (!(this.isIgnoreable(blockCheck) || this.isMoveableBlock(blockCheck) || this.isPlatform(blockCheck) || set.contains(blockCheck))) {
            return false;
        }
        set.add(p);
        ArrayList fails = new ArrayList();
        Arrays.asList(p.up(), p.down(), p.north(), p.south(), p.east(), p.west()).forEach(q -> {
            if (fails.isEmpty() && !set.contains(q) && !this.addToList(set, (BlockPos)q, up)) {
                fails.add(q);
            }
        });
        return fails.isEmpty();
    }

    private boolean activeOperation() {
        return this.rope != null && this.rope.isEntityAlive();
    }

    private boolean takeRope(boolean flag) {
        return InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, new ItemStack(BWMBlocks.ROPE), 1, !flag);
    }

    private boolean putRope(boolean flag) {
        return InvUtils.insert((IItemHandler)this.inventory, new ItemStack(BWMBlocks.ROPE, 1), !flag).isEmpty();
    }

    public boolean onJobCompleted(boolean up, int targetY, EntityExtendingRope theRope) {
        BlockPos ropePos = new BlockPos(this.pos.getX(), targetY - (up ? 1 : 0), this.pos.getZ());
        IBlockState state = this.getBlockWorld().getBlockState(ropePos);
        if (!up) {
            if ((this.getBlockWorld().isAirBlock(ropePos) || state.getBlock().isReplaceable((IBlockAccess)this.getBlockWorld(), ropePos)) && BWMBlocks.ROPE.canPlaceBlockAt(this.getBlockWorld(), ropePos) && this.takeRope(true)) {
                this.getBlockWorld().playSound(null, this.pos.down(), SoundEvents.BLOCK_GRASS_PLACE, SoundCategory.BLOCKS, 0.4f, 1.0f);
                this.getBlockWorld().setBlockState(ropePos, BWMBlocks.ROPE.getDefaultState());
            } else {
                this.tryNextOperation();
                theRope.setDead();
                return false;
            }
        }
        if ((theRope.getUp() ? this.canGoUp() : this.canGoDown(true)) && !theRope.isPathBlocked()) {
            theRope.setTargetY(targetY + (theRope.getUp() ? 1 : -1));
            if (up && !this.getBlockWorld().isAirBlock(ropePos.up())) {
                this.getBlockWorld().playSound(null, this.pos.down(), SoundEvents.BLOCK_GRASS_BREAK, SoundCategory.BLOCKS, 0.4f + this.getBlockWorld().rand.nextFloat() * 0.1f, 1.0f);
                this.getBlockWorld().setBlockToAir(ropePos.up());
                this.putRope(true);
            }
            return true;
        }
        this.tryNextOperation();
        theRope.setDead();
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound ropetag = new NBTTagCompound();
        if (this.rope != null) {
            this.rope.writeToNBTAtomically(ropetag);
        }
        tag.setTag("Rope", (NBTBase)ropetag);
        tag.setInteger("power", this.power);
        return super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.ropeTag = (NBTTagCompound)tag.getTag("Rope");
        this.power = tag.getInteger("power");
    }

    public void onLoad() {
        NBTTagList pos;
        super.onLoad();
        if (this.rope == null && !this.getWorld().isRemote && this.ropeTag != null && !this.ropeTag.hasNoTags() && (pos = (NBTTagList)this.ropeTag.getTag("Pos")) != null) {
            this.rope = (EntityExtendingRope)AnvilChunkLoader.readWorldEntityPos((NBTTagCompound)this.ropeTag, (World)this.getBlockWorld(), (double)pos.getDoubleAt(0), (double)pos.getDoubleAt(1), (double)pos.getDoubleAt(2), (boolean)true);
        }
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return -1;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        if (facing.getAxis().isHorizontal()) {
            return BWMAPI.IMPLEMENTATION.getPowerOutput(this.world, this.pos.offset(facing), facing.getOpposite());
        }
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 1;
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nonnull EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }

    @Override
    public int getMax() {
        return 1;
    }

    @Override
    public int getProgress() {
        return Math.min(this.power, 1);
    }
}

