/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.IColor;
import betterwithmods.common.blocks.mechanical.tile.TileAxleGenerator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.DimensionType;

public abstract class TileEntityBaseWindmill
extends TileAxleGenerator
implements IColor {
    protected int[] bladeMeta;

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < this.bladeMeta.length; ++i) {
            if (!tag.hasKey("Color_" + i)) continue;
            this.bladeMeta[i] = tag.getInteger("Color_" + i);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        for (int i = 0; i < this.bladeMeta.length; ++i) {
            t.setInteger("Color_" + i, this.bladeMeta[i]);
        }
        t.setByte("DyeIndex", this.dyeIndex);
        return t;
    }

    @Override
    public boolean dye(EnumDyeColor color) {
        boolean dyed = false;
        if (this.bladeMeta[this.dyeIndex] != color.getMetadata()) {
            this.bladeMeta[this.dyeIndex] = color.getMetadata();
            dyed = true;
            IBlockState state = this.getBlockWorld().getBlockState(this.pos);
            this.getBlockWorld().notifyBlockUpdate(this.pos, state, state, 2);
            this.markDirty();
        }
        this.dyeIndex = (byte)(this.dyeIndex + 1);
        if (this.dyeIndex > this.bladeMeta.length - 1) {
            this.dyeIndex = 0;
        }
        return dyed;
    }

    public int getBladeColor(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public int getColor(int index) {
        return this.bladeMeta[index];
    }

    @Override
    public void calculatePower() {
        int power = 0;
        if (this.isValid()) {
            power = this.world.provider.getDimensionType() == DimensionType.OVERWORLD ? (this.world.isThundering() ? 3 : (this.world.isRaining() ? 2 : 1)) : 1;
        }
        if (power != this.power) {
            this.setPower((byte)power);
        }
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }
}

