/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical.tile;

import betterwithmods.api.capabilities.CapabilityMechanicalPower;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.mechanical.BlockAxleGenerator;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.tile.TileBasic;
import betterwithmods.module.gameplay.Gameplay;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileAxleGenerator
extends TileBasic
implements ITickable,
IMechanicalPower {
    protected byte power = 0;
    public byte dyeIndex = 0;
    protected float runningSpeed = 0.4f;
    public float currentRotation = 0.0f;
    public float previousRotation = 0.0f;
    public float waterMod = 1.0f;
    protected boolean isValid;
    protected int tick;

    public abstract void calculatePower();

    public abstract void verifyIntegrity();

    public abstract int getRadius();

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        if (tag.hasKey("CurrentRotation")) {
            this.currentRotation = tag.getFloat("CurrentRotation");
        }
        if (tag.hasKey("RotationSpeed")) {
            this.previousRotation = tag.getFloat("RotationSpeed");
        }
        if (tag.hasKey("power")) {
            this.power = tag.getByte("power");
        }
        if (tag.hasKey("DyeIndex")) {
            this.dyeIndex = tag.getByte("DyeIndex");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagCompound t = super.writeToNBT(tag);
        t.setByte("power", this.power);
        t.setFloat("CurrentRotation", this.currentRotation);
        t.setFloat("RotationSpeed", this.previousRotation);
        return t;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getPrevRotation() {
        return this.previousRotation;
    }

    public void update() {
        ++this.tick;
        if (this.tick % 20 == 0 && this.getBlockWorld().getBlockState(this.pos).getBlock() instanceof BlockAxleGenerator) {
            this.verifyIntegrity();
            this.calculatePower();
        }
        if (this.isValid()) {
            if (this.power != 0) {
                this.previousRotation = (float)this.power * this.runningSpeed * this.waterMod;
                this.currentRotation += (float)(this.power * this.power) * this.runningSpeed * this.waterMod;
                this.currentRotation %= 360.0f;
                if (this.getBlockWorld().rand.nextInt(100) == 0) {
                    this.getBlockWorld().playSound(null, this.pos, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5f, this.getBlockWorld().rand.nextFloat() * 0.25f + 0.25f);
                }
            } else {
                this.previousRotation = 0.0f;
                this.currentRotation = 0.0f;
            }
        }
    }

    public boolean isOverworld() {
        return this.world.provider.isSurfaceWorld();
    }

    public boolean isEnd() {
        return this.world.provider.getDimensionType() == DimensionType.THE_END;
    }

    public boolean isNether() {
        return this.world.provider.isNether();
    }

    public void setPower(byte power) {
        this.power = power;
        this.world.setBlockState(this.pos, this.world.getBlockState(this.pos).withProperty((IProperty)IBlockActive.ACTIVE, (Comparable)Boolean.valueOf(power > 0)));
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.getBlock() != newState.getBlock();
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return Gameplay.generatorRenderDistance * Gameplay.generatorRenderDistance;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityMechanicalPower.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityMechanicalPower.MECHANICAL_POWER) {
            return (T)CapabilityMechanicalPower.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        return this.power;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 0;
    }

    public EnumFacing getOrientation() {
        if (this.world.getBlockState(this.pos).getBlock() instanceof BlockAxleGenerator) {
            EnumFacing.Axis axis = (EnumFacing.Axis)this.world.getBlockState(this.pos).getValue(DirUtils.AXIS);
            switch (axis) {
                case X: {
                    return EnumFacing.EAST;
                }
                case Z: {
                    return EnumFacing.SOUTH;
                }
            }
            return EnumFacing.UP;
        }
        return EnumFacing.UP;
    }

    @Override
    public World getBlockWorld() {
        return super.getWorld();
    }

    @Override
    public BlockPos getBlockPos() {
        return super.getPos();
    }

    @Override
    public Block getBlock() {
        return this.getBlockType();
    }
}

