/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.common.blocks.EnumTier;
import betterwithmods.common.blocks.mechanical.BlockAxle;
import betterwithmods.common.blocks.mechanical.tile.TileAxle;
import betterwithmods.common.blocks.mechanical.tile.TileSteelSaw;
import betterwithmods.util.DirUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockSteelSaw
extends BlockAxle {
    public BlockSteelSaw() {
        super(EnumTier.STEEL, 1, 3, 5);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSteelSaw();
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getDefaultState().withProperty(DirUtils.AXIS, (Comparable)facing.getAxis());
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.AXIS, ACTIVE});
    }

    @Override
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1)).withProperty(DirUtils.AXIS, (Comparable)DirUtils.getAxis(meta >> 1));
    }

    @Override
    public int getMetaFromState(IBlockState state) {
        int active = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 1 : 0;
        int axis = ((EnumFacing.Axis)state.getValue(DirUtils.AXIS)).ordinal();
        return active | axis << 1;
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public Optional<TileAxle> withTile(World world, BlockPos pos) {
        return Optional.of(this.getTile(world, pos));
    }

    @Override
    public TileAxle getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileAxle) {
            return (TileAxle)tile;
        }
        return null;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
    }
}

