/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IOverpower;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TileSaw;
import betterwithmods.common.damagesource.BWDamageSource;
import betterwithmods.module.gameplay.MechanicalBreakage;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSaw
extends BWMBlock
implements IBlockActive,
IOverpower {
    private static final float HEIGHT = 0.75f;
    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);

    public BlockSaw() {
        super(Material.WOOD);
        this.setHardness(2.0f);
        this.setSoundType(SoundType.WOOD);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileSaw();
    }

    public int tickRate(World world) {
        return 10;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, flX, flY, flZ, meta, placer, hand);
        return this.setFacingInBlock(state, DirUtils.getOpposite(facing));
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        world.setBlockState(pos, world.getBlockState(pos).withProperty((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.getActualState(world, pos);
        EnumFacing facing = this.getFacing(state);
        switch (facing) {
            case DOWN: {
                return D_AABB;
            }
            case UP: {
                return U_AABB;
            }
            case NORTH: {
                return N_AABB;
            }
            case SOUTH: {
                return S_AABB;
            }
            case WEST: {
                return W_AABB;
            }
        }
        return E_AABB;
    }

    public void neighborChanged(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        TileSaw tile;
        this.withTile(world, pos).ifPresent(TileSaw::onChanged);
        if (this.isActive(state) && !world.isRemote && (tile = this.getTile(world, pos)) != null) {
            tile.cut(world, pos, rand);
            world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world) + rand.nextInt(6), 5);
        }
    }

    @Override
    public void onChangeActive(World world, BlockPos pos, boolean newValue) {
        Random rand = world.rand;
        this.emitSawParticles(world, pos, rand, EnumParticleTypes.SMOKE_NORMAL, 5);
        if (newValue) {
            world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world) + rand.nextInt(6), 5);
            world.playSound(null, pos, BWSounds.SAW_CUT, SoundCategory.BLOCKS, 1.0f + rand.nextFloat() * 0.1f, 1.5f + rand.nextFloat() * 0.1f);
        } else {
            world.playSound(null, pos, BWSounds.SAW_CUT, SoundCategory.BLOCKS, 1.0f + rand.nextFloat() * 0.1f, 0.75f + rand.nextFloat() * 0.1f);
        }
    }

    public void onEntityCollidedWithBlock(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.isActive(state) && entity instanceof EntityLivingBase) {
            EnumFacing dir = this.getFacing((IBlockAccess)world, pos);
            BWDamageSource.FakeDamageSource source = BWDamageSource.getSawDamage();
            int damage = 4;
            boolean unobstructed = true;
            for (int i = 0; i < 3; ++i) {
                BlockPos pos2 = new BlockPos(pos.getX(), pos.getY() - i, pos.getZ()).offset(dir);
                Block block = world.getBlockState(pos2).getBlock();
                IBlockState blockState = world.getBlockState(pos2);
                if (this.isChoppingBlock(blockState)) {
                    source = BWDamageSource.getChoppingBlockDamage();
                    damage *= 3;
                    if (((BlockAesthetic.EnumType)((Object)blockState.getValue(BlockAesthetic.TYPE))).getMeta() != 0 || !unobstructed) break;
                    world.setBlockState(pos2, BWMBlocks.AESTHETIC.getDefaultState().withProperty(BlockAesthetic.TYPE, (Comparable)((Object)BlockAesthetic.EnumType.CHOPBLOCKBLOOD)));
                    break;
                }
                if (!world.isAirBlock(pos2) && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock)) break;
                if (world.isAirBlock(pos2)) continue;
                unobstructed = false;
            }
            if (source != null && entity.attackEntityFrom((DamageSource)source, (float)damage)) {
                ((EntityLivingBase)entity).recentlyHit = 60;
                world.playSound(null, pos, BWSounds.SAW_CUT, SoundCategory.BLOCKS, 1.0f + world.rand.nextFloat() * 0.1f, 1.5f + world.rand.nextFloat() * 0.1f);
            }
        }
    }

    public boolean isChoppingBlock(IBlockState state) {
        return state.getBlock() == BWMBlocks.AESTHETIC && ((BlockAesthetic.EnumType)((Object)state.getValue(BlockAesthetic.TYPE))).getMeta() < 2;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != this.getFacing(state);
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacing(world.getBlockState(pos));
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.getValue((IProperty)DirUtils.FACING);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        if (MechanicalBreakage.saw) {
            InvUtils.ejectBrokenItems(world, pos, new ResourceLocation("betterwithmods", "block/saw"));
        }
        world.playSound(null, pos, SoundEvents.ENTITY_GENERIC_EXPLODE, SoundCategory.BLOCKS, 0.3f, world.rand.nextFloat() * 0.1f + 0.45f);
        world.setBlockToAir(pos);
    }

    public void emitSawParticles(World world, BlockPos pos, Random rand, EnumParticleTypes type, int amount) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        float xPos = pos.getX();
        float yPos = pos.getY();
        float zPos = pos.getZ();
        float xExtent = 0.0f;
        float zExtent = 0.0f;
        switch (facing) {
            case DOWN: {
                xPos += 0.5f;
                zPos += 0.5f;
                xExtent = 1.0f;
                break;
            }
            case UP: {
                xPos += 0.5f;
                zPos += 0.5f;
                yPos += 1.0f;
                xExtent = 1.0f;
                break;
            }
            case NORTH: {
                xPos += 0.5f;
                yPos += 0.5f;
                xExtent = 1.0f;
                break;
            }
            case SOUTH: {
                xPos += 0.5f;
                yPos += 0.5f;
                zPos += 1.0f;
                xExtent = 1.0f;
                break;
            }
            case WEST: {
                yPos += 0.5f;
                zPos += 0.5f;
                zExtent = 1.0f;
                break;
            }
            default: {
                yPos += 0.5f;
                zPos += 0.5f;
                xPos += 1.0f;
                zExtent = 1.0f;
            }
        }
        for (int i = 0; i < amount; ++i) {
            float smokeX = xPos + (rand.nextFloat() - 0.5f) * xExtent;
            float smokeY = yPos + rand.nextFloat() * 0.1f;
            float smokeZ = zPos + (rand.nextFloat() - 0.5f) * zExtent;
            world.spawnParticle(type, (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isActive(state)) {
            this.emitSawParticles(world, pos, rand, EnumParticleTypes.SMOKE_NORMAL, 5);
            List entities = world.getEntitiesWithinAABB(EntityLivingBase.class, new AxisAlignedBB(pos, pos.add(1, 1, 1)));
            if (!entities.isEmpty()) {
                this.emitSawParticles(world, pos, rand, EnumParticleTypes.REDSTONE, 20);
            }
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        int active = meta & 1;
        int facing = meta >> 1;
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active == 1)).withProperty((IProperty)DirUtils.FACING, (Comparable)EnumFacing.getFront((int)facing));
    }

    public int getMetaFromState(IBlockState state) {
        int active = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 1 : 0;
        int facing = ((EnumFacing)state.getValue((IProperty)DirUtils.FACING)).getIndex() << 1;
        return active | facing;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE, DirUtils.FACING});
    }

    public Optional<TileSaw> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(this.getTile(world, pos));
    }

    public TileSaw getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileSaw) {
            return (TileSaw)tile;
        }
        return null;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getFacing(state) != EnumFacing.UP;
    }

    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != this.getFacing(state).getOpposite() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (super.rotateBlock(world, pos, axis)) {
            this.setActive(world, pos, false);
            return true;
        }
        return false;
    }
}

