/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.mechanical;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.api.block.IOverpower;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.common.blocks.mechanical.IBlockActive;
import betterwithmods.common.blocks.mechanical.tile.TilePump;
import betterwithmods.util.DirUtils;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockPump
extends BlockRotate
implements IBlockActive,
IMultiVariants,
IOverpower {
    public BlockPump() {
        super(Material.WOOD);
        this.setCreativeTab(BWCreativeTabs.BWTAB);
        this.setTickRandomly(true);
        this.setHardness(3.5f);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.NORTH).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.setSoundType(SoundType.WOOD);
    }

    public static boolean hasWaterToPump(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        EnumFacing direction = (EnumFacing)state.getValue((IProperty)DirUtils.HORIZONTAL);
        BlockPos source = DirUtils.movePos(pos, direction);
        IBlockState sourceState = world.getBlockState(source);
        Block block = sourceState.getBlock();
        Material mat = block.getMaterial(state);
        return block instanceof BlockFluidBase && ((BlockFluidBase)block).getFluid() == FluidRegistry.WATER || block instanceof BlockLiquid && mat == Material.WATER;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=false,facing=north"};
    }

    public int tickRate(World world) {
        return 5;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, entity.getHorizontalFacing().getOpposite());
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFlatFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)facing);
    }

    public IBlockState getStateFromMeta(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).withProperty((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.getHorizontal((int)meta));
    }

    public int getMetaFromState(IBlockState state) {
        int meta = (Boolean)state.getValue((IProperty)ACTIVE) != false ? 8 : 0;
        return meta + ((EnumFacing)state.getValue((IProperty)DirUtils.HORIZONTAL)).getIndex();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.HORIZONTAL, ACTIVE});
    }

    public void onBlockAdded(World world, BlockPos pos, IBlockState state) {
        super.onBlockAdded(world, pos, state);
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.withTile(worldIn, pos).ifPresent(TilePump::onChanged);
    }

    public void updateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        this.withTile(world, pos).ifPresent(TilePump::onChanged);
        if (this.isActive(state) && world.isAirBlock(pos.up()) && BlockPump.hasWaterToPump(world, pos)) {
            world.setBlockState(pos.up(), BWMBlocks.TEMP_LIQUID_SOURCE.getDefaultState());
        }
        world.scheduleBlockUpdate(pos, (Block)this, this.tickRate(world), 5);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.setBlockState(pos, state.withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).cycleProperty((IProperty)DirUtils.HORIZONTAL));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TilePump();
    }

    @Override
    public void overpower(World world, BlockPos pos) {
    }

    public Optional<TilePump> withTile(World world, BlockPos pos) {
        return Optional.ofNullable(this.getTile(world, pos));
    }

    public TilePump getTile(World world, BlockPos pos) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TilePump) {
            return (TilePump)tile;
        }
        return null;
    }
}

